/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.squidb.json;

import com.yahoo.squidb.json.JSONArgumentFunction;
import com.yahoo.squidb.sql.Field;
import com.yahoo.squidb.sql.Function;
import com.yahoo.squidb.utility.VersionCode;

public class JSONFunctions {
    public static final VersionCode JSON1_MIN_VERSION = new VersionCode(3, 9, 0, 0);
    public static final VersionCode JSON1_GROUP_FUNCTIONS_VERSION = new VersionCode(3, 10, 0, 0);

    public static Function<String> json(Object arg) {
        return new JSONArgumentFunction<String>("json", arg, new Object[0]);
    }

    public static Function<String> jsonArray(Object ... args) {
        return new JSONArgumentFunction<String>("json_array", null, args);
    }

    public static Function<Integer> jsonArrayLength(Object json) {
        return new JSONArgumentFunction<Integer>("json_array_length", json, new Object[0]);
    }

    public static Function<Integer> jsonArrayLength(Object json, String path) {
        return new JSONArgumentFunction<Integer>("json_array_length", json, path);
    }

    public static <T> Function<T> jsonExtract(Object json, String path) {
        return new JSONArgumentFunction("json_extract", json, path);
    }

    public static Function<String> jsonExtract(Object json, String ... paths) {
        return new JSONArgumentFunction<String>("json_extract", json, paths);
    }

    public static Function<String> jsonType(Object json) {
        return new JSONArgumentFunction<String>("json_type", json, new Object[0]);
    }

    public static Function<String> jsonType(Object json, String path) {
        return new JSONArgumentFunction<String>("json_type", json, path);
    }

    public static Function<String> jsonInsert(Object json, Object ... pathValuePairs) {
        return new JSONArgumentFunction<String>("json_insert", json, pathValuePairs);
    }

    public static Function<String> jsonReplace(Object json, Object ... pathValuePairs) {
        return new JSONArgumentFunction<String>("json_replace", json, pathValuePairs);
    }

    public static Function<String> jsonSet(Object json, Object ... pathValuePairs) {
        return new JSONArgumentFunction<String>("json_set", json, pathValuePairs);
    }

    public static Function<String> jsonRemove(Object json, Object ... paths) {
        return new JSONArgumentFunction<String>("json_remove", json, paths);
    }

    public static Function<String> jsonObject(Object ... labelValuePairs) {
        return new JSONArgumentFunction<String>("json_object", null, labelValuePairs);
    }

    public static Function<Integer> jsonValid(Object arg) {
        return new JSONArgumentFunction<Integer>("json_valid", arg, new Object[0]);
    }

    public static Function<String> jsonGroupArray(Field<?> arg) {
        return new JSONArgumentFunction<String>(JSON1_GROUP_FUNCTIONS_VERSION, "json_group_array", arg, new Object[0]);
    }

    public static Function<String> jsonGroupObject(Field<?> keys, Field<?> values) {
        return new JSONArgumentFunction<String>(JSON1_GROUP_FUNCTIONS_VERSION, "json_group_object", keys, values);
    }
}

