/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.squidb.json;

import com.yahoo.squidb.data.AbstractModel;
import com.yahoo.squidb.json.JSONMapper;
import com.yahoo.squidb.json.JSONProperty;
import com.yahoo.squidb.sql.SqlUtils;
import com.yahoo.squidb.utility.Logger;
import java.lang.reflect.Type;

public class JSONPropertySupport {
    private static final String TAG = "squidb-json";
    private static JSONMapper MAPPER = null;

    public static void setJSONMapper(JSONMapper jsonMapper) {
        MAPPER = jsonMapper;
    }

    public static <T> T getValueFromJSON(AbstractModel model, JSONProperty<T> property, Type javaType) {
        String transitoryKey = JSONPropertySupport.transitoryKeyForProperty(property);
        JSONPropertySupport.checkCacheIntegrity(model, property, transitoryKey);
        if (!model.hasTransitory(transitoryKey)) {
            T data = null;
            String json = (String)model.get(property);
            if (json != null) {
                try {
                    if (MAPPER == null) {
                        throw new NullPointerException("JSONPropertySupport needs to be initialized with a JSONMapper instance using setJSONMapper()");
                    }
                    data = MAPPER.fromJSON(json, javaType);
                }
                catch (Exception e) {
                    Logger.w((String)TAG, (String)("Error deserializing JSON string: " + json), (Throwable)e);
                    model.clearValue(property);
                }
            }
            JSONPropertySupport.putJSONTransitory(model, transitoryKey, data, json);
            return data;
        }
        JSONObjectHolder<T> holder = JSONPropertySupport.getJSONTransitory(model, transitoryKey);
        return holder.parsedObject;
    }

    public static <T> boolean setValueAsJSON(AbstractModel model, JSONProperty<T> property, T data, Type javaType) {
        try {
            String json = null;
            if (data != null) {
                if (MAPPER == null) {
                    throw new NullPointerException("JSONPropertySupport needs to be initialized with a JSONMapper instance using setJSONMapper()");
                }
                json = MAPPER.toJSON(data, javaType);
                if (model.containsNonNullValue(property) && json.equals(model.get(property))) {
                    return false;
                }
            }
            model.set(property, json);
            JSONPropertySupport.putJSONTransitory(model, JSONPropertySupport.transitoryKeyForProperty(property), data, json);
            return true;
        }
        catch (Exception e) {
            Logger.w((String)TAG, (String)("Error serializing object to JSON string: " + data), (Throwable)e);
            return false;
        }
    }

    private static String transitoryKeyForProperty(JSONProperty<?> property) {
        return "json__" + property.getName();
    }

    private static <T> void putJSONTransitory(AbstractModel model, String transitoryKey, T data, String jsonString) {
        model.putTransitory(transitoryKey, new JSONObjectHolder<T>(data, jsonString));
    }

    private static void checkCacheIntegrity(AbstractModel model, JSONProperty<?> property, String transitoryKey) {
        String jsonValue;
        if (!model.hasTransitory(transitoryKey)) {
            return;
        }
        JSONObjectHolder holder = JSONPropertySupport.getJSONTransitory(model, transitoryKey);
        if ((model.containsValue(property) || model.getDefaultValues().containsKey(property.getName())) && SqlUtils.equals((String)holder.jsonString, (String)(jsonValue = (String)model.get(property)))) {
            return;
        }
        model.clearTransitory(transitoryKey);
    }

    private static <T> JSONObjectHolder<T> getJSONTransitory(AbstractModel model, String transitoryKey) {
        return (JSONObjectHolder)model.getTransitory(transitoryKey);
    }

    private static class JSONObjectHolder<T> {
        final T parsedObject;
        final String jsonString;

        JSONObjectHolder(T parsedObject, String jsonString) {
            this.parsedObject = parsedObject;
            this.jsonString = jsonString;
        }
    }
}

