/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.squidb.reactive;

import com.yahoo.squidb.data.AbstractModel;
import com.yahoo.squidb.data.DataChangedNotifier;
import com.yahoo.squidb.data.SquidDatabase;
import com.yahoo.squidb.sql.Property;
import com.yahoo.squidb.sql.SqlTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import rx.Observable;
import rx.functions.Func1;
import rx.subjects.PublishSubject;

public abstract class ReactiveSquidDatabase
extends SquidDatabase {
    private final PublishSubject<Set<SqlTable<?>>> changedTablePublisher = PublishSubject.create();
    private static final Set<SqlTable<?>> INITIAL_TABLE = new HashSet();

    public ReactiveSquidDatabase() {
        this.registerDataChangedNotifier(new PublishingDataChangedNotifier());
    }

    public <T extends SqlTable<?>> Observable<T> observeTable(T table) {
        return this.observeTable(table, false);
    }

    public <T extends SqlTable<?>> Observable<T> observeTable(T table, boolean emitOnFirstSubscribe) {
        return this.observeTableAndEmit(table, table, emitOnFirstSubscribe);
    }

    public <T> Observable<T> observeTableAndEmit(SqlTable<?> table, T objectToEmit) {
        return this.observeTableAndEmit(table, objectToEmit, false);
    }

    public <T> Observable<T> observeTableAndEmit(final SqlTable<?> table, T objectToEmit, boolean emitOnFirstSubscribe) {
        if (table == null) {
            throw new IllegalArgumentException("Cannot observe a null table");
        }
        return this.observeAndEmit(objectToEmit, new Func1<Set<SqlTable<?>>, Boolean>(){

            public Boolean call(Set<SqlTable<?>> changedTables) {
                return changedTables.contains(table);
            }
        }, emitOnFirstSubscribe);
    }

    public <T> Observable<T> observeTablesAndEmit(Collection<? extends SqlTable<?>> tables, T objectToEmit) {
        return this.observeTablesAndEmit(tables, objectToEmit, false);
    }

    public <T> Observable<T> observeTablesAndEmit(final Collection<? extends SqlTable<?>> tables, T objectToEmit, boolean emitOnFirstSubscribe) {
        if (tables == null) {
            throw new IllegalArgumentException("Cannot observe a null table collection");
        }
        return this.observeAndEmit(objectToEmit, new Func1<Set<SqlTable<?>>, Boolean>(){

            public Boolean call(Set<SqlTable<?>> changedTables) {
                for (SqlTable table : tables) {
                    if (!changedTables.contains(table)) continue;
                    return true;
                }
                return false;
            }
        }, emitOnFirstSubscribe);
    }

    private <T> Observable<T> observeAndEmit(final T objectToEmit, Func1<Set<SqlTable<?>>, Boolean> tableFilter, boolean emitOnFirstSubscribe) {
        Observable observable = this.changedTablePublisher.filter(tableFilter);
        if (emitOnFirstSubscribe) {
            observable = observable.startWith(INITIAL_TABLE);
        }
        return observable.map(new Func1<Set<SqlTable<?>>, T>(){

            public T call(Set<SqlTable<?>> sqlTables) {
                return objectToEmit;
            }
        });
    }

    static {
        INITIAL_TABLE.add(new SqlTable<AbstractModel>(null, null, "<initial>"){

            protected SqlTable<AbstractModel> asNewAliasWithPropertiesArray(String newAlias, Property<?>[] newProperties) {
                throw new UnsupportedOperationException("Fake initial table for ReactiveSquidDatabase should never be aliased");
            }
        });
    }

    private class PublishingDataChangedNotifier
    extends DataChangedNotifier<SqlTable<?>> {
        private PublishingDataChangedNotifier() {
        }

        protected boolean accumulateNotificationObjects(Set<SqlTable<?>> accumulatorSet, SqlTable<?> table, SquidDatabase database, DataChangedNotifier.DBOperation operation, AbstractModel modelValues, long rowId) {
            return accumulatorSet.add(table);
        }

        protected void sendNotificationsToAll(SquidDatabase database, Set<SqlTable<?>> notifyObjects) {
            ReactiveSquidDatabase.this.changedTablePublisher.onNext(notifyObjects);
        }

        protected void sendNotification(SquidDatabase database, SqlTable<?> notifyObject) {
            throw new UnsupportedOperationException("Can't send onNext to the publisher with a single table. This should never happen anyway.");
        }
    }
}

