/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.evaluable;

import com.yandex.div.evaluable.Evaluable;
import com.yandex.div.evaluable.EvaluableException;
import com.yandex.div.evaluable.EvaluableExceptionKt;
import com.yandex.div.evaluable.EvaluableType;
import com.yandex.div.evaluable.Function;
import com.yandex.div.evaluable.FunctionProvider;
import com.yandex.div.evaluable.IntegerOverflow;
import com.yandex.div.evaluable.MissingVariableException;
import com.yandex.div.evaluable.VariableProvider;
import com.yandex.div.evaluable.internal.Token;
import com.yandex.div.evaluable.types.Color;
import com.yandex.div.evaluable.types.DateTime;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ5\u0010\u0010\u001a\u00020\u0001\"\u000e\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\b2\u0006\u0010\u0015\u001a\u0002H\bH\u0002\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J \u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J\u0015\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ&\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00012\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!H\u0002J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020)H\u0000\u00a2\u0006\u0002\b*J\u0015\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b2J\u0015\u00103\u001a\u00020\u00012\u0006\u00100\u001a\u000204H\u0000\u00a2\u0006\u0002\b5R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/yandex/div/evaluable/Evaluator;", "", "variableProvider", "Lcom/yandex/div/evaluable/VariableProvider;", "functionProvider", "Lcom/yandex/div/evaluable/FunctionProvider;", "(Lcom/yandex/div/evaluable/VariableProvider;Lcom/yandex/div/evaluable/FunctionProvider;)V", "eval", "T", "expr", "Lcom/yandex/div/evaluable/Evaluable;", "(Lcom/yandex/div/evaluable/Evaluable;)Ljava/lang/Object;", "evalBinary", "binary", "Lcom/yandex/div/evaluable/Evaluable$Binary;", "evalBinary$div_evaluable", "evalComparableTypes", "", "operator", "Lcom/yandex/div/evaluable/internal/Token$Operator$Binary$Comparison;", "left", "right", "(Lcom/yandex/div/evaluable/internal/Token$Operator$Binary$Comparison;Ljava/lang/Comparable;Ljava/lang/Comparable;)Ljava/lang/Object;", "evalComparison", "evalEquality", "Lcom/yandex/div/evaluable/internal/Token$Operator$Binary$Equality;", "evalFunctionCall", "functionCall", "Lcom/yandex/div/evaluable/Evaluable$FunctionCall;", "evalFunctionCall$div_evaluable", "evalLogical", "Lcom/yandex/div/evaluable/internal/Token$Operator$Binary$Logical;", "rightEvaluator", "Lkotlin/Function0;", "evalStringTemplate", "", "stringTemplate", "Lcom/yandex/div/evaluable/Evaluable$StringTemplate;", "evalStringTemplate$div_evaluable", "evalTernary", "ternary", "Lcom/yandex/div/evaluable/Evaluable$Ternary;", "evalTernary$div_evaluable", "evalUnary", "unary", "Lcom/yandex/div/evaluable/Evaluable$Unary;", "evalUnary$div_evaluable", "evalValue", "call", "Lcom/yandex/div/evaluable/Evaluable$Value;", "evalValue$div_evaluable", "evalVariable", "Lcom/yandex/div/evaluable/Evaluable$Variable;", "evalVariable$div_evaluable", "Companion", "div-evaluable"})
public final class Evaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VariableProvider variableProvider;
    @NotNull
    private final FunctionProvider functionProvider;

    public Evaluator(@NotNull VariableProvider variableProvider, @NotNull FunctionProvider functionProvider) {
        Intrinsics.checkNotNullParameter((Object)variableProvider, (String)"variableProvider");
        Intrinsics.checkNotNullParameter((Object)functionProvider, (String)"functionProvider");
        this.variableProvider = variableProvider;
        this.functionProvider = functionProvider;
    }

    public final <T> T eval(@NotNull Evaluable expr) throws EvaluableException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        try {
            object = expr.eval$div_evaluable(this);
        }
        catch (EvaluableException e) {
            throw e;
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new EvaluableException(string, e);
        }
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Object evalUnary$div_evaluable(@NotNull Evaluable.Unary unary) {
        Constable constable;
        Intrinsics.checkNotNullParameter((Object)unary, (String)"unary");
        Object literal = this.eval(unary.getExpression());
        unary.updateIsCacheable$div_evaluable(unary.getExpression().checkIsCacheable());
        Token.Operator operator = unary.getToken();
        if (operator instanceof Token.Operator.Unary.Plus) {
            Object t = literal;
            if (t instanceof Long) {
                constable = ((Number)literal).longValue();
                return constable;
            }
            if (t instanceof Double) {
                constable = ((Number)literal).doubleValue();
                return constable;
            }
            EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(Intrinsics.stringPlus((String)"+", literal), "A Number is expected after a unary plus.", null, 4, null);
            throw new KotlinNothingValueException();
        }
        if (operator instanceof Token.Operator.Unary.Minus) {
            Object t = literal;
            if (t instanceof Long) {
                constable = -((Number)literal).longValue();
                return constable;
            }
            if (t instanceof Double) {
                constable = -((Number)literal).doubleValue();
                return constable;
            }
            EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(Intrinsics.stringPlus((String)"-", literal), "A Number is expected after a unary minus.", null, 4, null);
            throw new KotlinNothingValueException();
        }
        if (!Intrinsics.areEqual((Object)operator, (Object)Token.Operator.Unary.Not.INSTANCE)) throw new EvaluableException(unary.getToken() + " was incorrectly parsed as a unary operator.", null, 2, null);
        if (!(literal instanceof Boolean)) {
            EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(Intrinsics.stringPlus((String)"!", literal), "A Boolean is expected after a unary not.", null, 4, null);
            throw new KotlinNothingValueException();
        }
        constable = Boolean.valueOf((Boolean)literal == false);
        return constable;
    }

    @NotNull
    public final Object evalBinary$div_evaluable(@NotNull Evaluable.Binary binary) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Object left = this.eval(binary.getLeft());
        binary.updateIsCacheable$div_evaluable(binary.getLeft().checkIsCacheable());
        if (binary.getToken() instanceof Token.Operator.Binary.Logical) {
            return this.evalLogical((Token.Operator.Binary.Logical)binary.getToken(), left, (Function0<? extends Object>)((Function0)new Function0<Object>(this, binary){
                final /* synthetic */ Evaluator this$0;
                final /* synthetic */ Evaluable.Binary $binary;
                {
                    this.this$0 = $receiver;
                    this.$binary = $binary;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    T res = this.this$0.eval(this.$binary.getRight());
                    this.$binary.updateIsCacheable$div_evaluable(this.$binary.getRight().checkIsCacheable());
                    return res;
                }
            }));
        }
        Object right = this.eval(binary.getRight());
        binary.updateIsCacheable$div_evaluable(binary.getRight().checkIsCacheable());
        if (!Intrinsics.areEqual(left.getClass(), right.getClass())) {
            EvaluableExceptionKt.throwExceptionOnEvaluationFailed(binary.getToken(), left, right);
            throw new KotlinNothingValueException();
        }
        Token.Operator.Binary binary2 = binary.getToken();
        if (binary2 instanceof Token.Operator.Binary.Equality) {
            object = this.evalEquality((Token.Operator.Binary.Equality)binary.getToken(), left, right);
        } else if (binary2 instanceof Token.Operator.Binary.Sum) {
            object = Companion.evalSum$div_evaluable((Token.Operator.Binary.Sum)binary.getToken(), left, right);
        } else if (binary2 instanceof Token.Operator.Binary.Factor) {
            object = Companion.evalFactor$div_evaluable((Token.Operator.Binary.Factor)binary.getToken(), left, right);
        } else if (binary2 instanceof Token.Operator.Binary.Comparison) {
            object = this.evalComparison((Token.Operator.Binary.Comparison)binary.getToken(), left, right);
        } else {
            EvaluableExceptionKt.throwExceptionOnEvaluationFailed(binary.getToken(), left, right);
            throw new KotlinNothingValueException();
        }
        return object;
    }

    private final Object evalLogical(Token.Operator.Binary.Logical operator, Object left, Function0<? extends Object> rightEvaluator) {
        if (!(left instanceof Boolean)) {
            EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(left + ' ' + operator + " ...", "" + '\'' + operator + "' must be called with boolean operands.", null, 4, null);
            throw new KotlinNothingValueException();
        }
        if (operator instanceof Token.Operator.Binary.Logical.Or && ((Boolean)left).booleanValue()) {
            return left;
        }
        if (operator instanceof Token.Operator.Binary.Logical.And && !((Boolean)left).booleanValue()) {
            return left;
        }
        Object right = rightEvaluator.invoke();
        if (!(right instanceof Boolean)) {
            EvaluableExceptionKt.throwExceptionOnEvaluationFailed(operator, left, right);
            throw new KotlinNothingValueException();
        }
        return operator instanceof Token.Operator.Binary.Logical.Or ? ((Boolean)left).booleanValue() || ((Boolean)right).booleanValue() : (Boolean)left != false && (Boolean)right != false;
    }

    private final Object evalEquality(Token.Operator.Binary.Equality operator, Object left, Object right) {
        boolean bl;
        Token.Operator.Binary.Equality equality = operator;
        if (equality instanceof Token.Operator.Binary.Equality.Equal) {
            bl = Intrinsics.areEqual((Object)left, (Object)right);
        } else if (equality instanceof Token.Operator.Binary.Equality.NotEqual) {
            bl = !Intrinsics.areEqual((Object)left, (Object)right);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final Object evalComparison(Token.Operator.Binary.Comparison operator, Object left, Object right) {
        if (left instanceof Double && right instanceof Double) {
            return this.evalComparableTypes(operator, (Comparable)left, (Comparable)right);
        }
        if (left instanceof Long && right instanceof Long) {
            return this.evalComparableTypes(operator, (Comparable)left, (Comparable)right);
        }
        if (left instanceof DateTime && right instanceof DateTime) {
            return this.evalComparableTypes(operator, (Comparable)left, (Comparable)right);
        }
        EvaluableExceptionKt.throwExceptionOnEvaluationFailed(operator, left, right);
        throw new KotlinNothingValueException();
    }

    private final <T extends Comparable<? super T>> Object evalComparableTypes(Token.Operator.Binary.Comparison operator, T left, T right) {
        boolean bl;
        Token.Operator.Binary.Comparison comparison = operator;
        if (comparison instanceof Token.Operator.Binary.Comparison.Less) {
            bl = left.compareTo(right) < 0;
        } else if (comparison instanceof Token.Operator.Binary.Comparison.LessOrEqual) {
            bl = left.compareTo(right) <= 0;
        } else if (comparison instanceof Token.Operator.Binary.Comparison.GreaterOrEqual) {
            bl = left.compareTo(right) >= 0;
        } else if (comparison instanceof Token.Operator.Binary.Comparison.Greater) {
            bl = left.compareTo(right) > 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object evalTernary$div_evaluable(@NotNull Evaluable.Ternary ternary) {
        Intrinsics.checkNotNullParameter((Object)ternary, (String)"ternary");
        if (ternary.getToken() instanceof Token.Operator.TernaryIfElse) {
            Object t;
            Object condition = this.eval(ternary.getFirstExpression());
            ternary.updateIsCacheable$div_evaluable(ternary.getFirstExpression().checkIsCacheable());
            if (!(condition instanceof Boolean)) {
                EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(ternary.getFirstExpression() + " ? " + ternary.getSecondExpression() + " : " + ternary.getThirdExpression(), "Ternary must be called with a Boolean value as a condition.", null, 4, null);
                throw new KotlinNothingValueException();
            }
            if (((Boolean)condition).booleanValue()) {
                Object res = this.eval(ternary.getSecondExpression());
                ternary.updateIsCacheable$div_evaluable(ternary.getSecondExpression().checkIsCacheable());
                t = res;
            } else {
                void var3_4;
                Object res = this.eval(ternary.getThirdExpression());
                ternary.updateIsCacheable$div_evaluable(ternary.getThirdExpression().checkIsCacheable());
                t = var3_4;
            }
            return t;
        }
        EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(ternary.getRawExpr(), ternary.getToken() + " was incorrectly parsed as a ternary operator.", null, 4, null);
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object evalFunctionCall$div_evaluable(@NotNull Evaluable.FunctionCall functionCall) {
        Function $i$f$map2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        List arguments = new ArrayList();
        for (Evaluable arg : functionCall.getArguments()) {
            arguments.add(this.eval(arg));
            functionCall.updateIsCacheable$div_evaluable(arg.checkIsCacheable());
        }
        Iterable $this$map$iv = arguments;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            EvaluableType evaluableType;
            void arg;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EvaluableType.Companion this_$iv = EvaluableType.Companion;
            boolean $i$f$of = false;
            void var15_18 = arg;
            if (var15_18 instanceof Long) {
                evaluableType = EvaluableType.INTEGER;
            } else if (var15_18 instanceof Double) {
                evaluableType = EvaluableType.NUMBER;
            } else if (var15_18 instanceof Boolean) {
                evaluableType = EvaluableType.BOOLEAN;
            } else if (var15_18 instanceof String) {
                evaluableType = EvaluableType.STRING;
            } else if (var15_18 instanceof DateTime) {
                evaluableType = EvaluableType.DATETIME;
            } else if (var15_18 instanceof Color) {
                evaluableType = EvaluableType.COLOR;
            } else {
                if (var15_18 == null) {
                    throw new EvaluableException("Unable to find type for null", null, 2, null);
                }
                void v1 = arg;
                Intrinsics.checkNotNull((Object)v1);
                throw new EvaluableException(Intrinsics.stringPlus((String)"Unable to find type for ", (Object)v1.getClass().getName()), null, 2, null);
            }
            collection.add(evaluableType);
        }
        List argTypes = (List)destination$iv$iv;
        try {
            $i$f$map2 = this.functionProvider.get(functionCall.getToken().getName(), argTypes);
        }
        catch (EvaluableException e) {
            String string = functionCall.getToken().getName();
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            EvaluableExceptionKt.throwExceptionOnFunctionEvaluationFailed$default(string, arguments, string2, null, 8, null);
            throw new KotlinNothingValueException();
        }
        Function function = $i$f$map2;
        functionCall.updateIsCacheable$div_evaluable(function.isPure());
        try {
            return function.invoke(arguments);
        }
        catch (IntegerOverflow e) {
            throw new IntegerOverflow(EvaluableExceptionKt.functionToMessageFormat(function.getName(), arguments), null, 2, null);
        }
    }

    @NotNull
    public final String evalStringTemplate$div_evaluable(@NotNull Evaluable.StringTemplate stringTemplate) {
        Intrinsics.checkNotNullParameter((Object)stringTemplate, (String)"stringTemplate");
        List stringParts = new ArrayList();
        for (Evaluable arg : stringTemplate.getArguments()) {
            String value = this.eval(arg).toString();
            stringParts.add(value);
            stringTemplate.updateIsCacheable$div_evaluable(arg.checkIsCacheable());
        }
        return CollectionsKt.joinToString$default((Iterable)stringParts, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final Object evalValue$div_evaluable(@NotNull Evaluable.Value call) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Token.Operand.Literal token = call.getToken();
        if (token instanceof Token.Operand.Literal.Num) {
            serializable = ((Token.Operand.Literal.Num)token).unbox-impl();
        } else if (token instanceof Token.Operand.Literal.Bool) {
            serializable = Boolean.valueOf(((Token.Operand.Literal.Bool)token).unbox-impl());
        } else if (token instanceof Token.Operand.Literal.Str) {
            serializable = (Serializable)((Object)((Token.Operand.Literal.Str)token).unbox-impl());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return serializable;
    }

    @NotNull
    public final Object evalVariable$div_evaluable(@NotNull Evaluable.Variable call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Object object = this.variableProvider.get(call.getToken-A4lXSVo());
        if (object == null) {
            throw new MissingVariableException(call.getToken-A4lXSVo(), null, 2, null);
        }
        return object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\bJ%\u0010\t\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/yandex/div/evaluable/Evaluator$Companion;", "", "()V", "evalFactor", "operator", "Lcom/yandex/div/evaluable/internal/Token$Operator$Binary$Factor;", "left", "right", "evalFactor$div_evaluable", "evalSum", "Lcom/yandex/div/evaluable/internal/Token$Operator$Binary$Sum;", "evalSum$div_evaluable", "div-evaluable"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final Object evalSum$div_evaluable(@NotNull Token.Operator.Binary.Sum operator, @NotNull Object left, @NotNull Object right) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            if (left instanceof String && right instanceof String) {
                if (operator instanceof Token.Operator.Binary.Sum.Plus) {
                    object = "" + left + right;
                    return object;
                }
                EvaluableExceptionKt.throwExceptionOnEvaluationFailed(operator, left, right);
                throw new KotlinNothingValueException();
            }
            if (left instanceof Long && right instanceof Long) {
                Token.Operator.Binary.Sum sum = operator;
                if (sum instanceof Token.Operator.Binary.Sum.Plus) {
                    long result = ((Number)left).longValue() + ((Number)right).longValue();
                    if (((((Number)left).longValue() ^ result) & (((Number)right).longValue() ^ result)) >= 0L) return result;
                    throw new IntegerOverflow(left + " + " + right, null, 2, null);
                }
                if (!(sum instanceof Token.Operator.Binary.Sum.Minus)) throw new NoWhenBranchMatchedException();
                long result = ((Number)left).longValue() - ((Number)right).longValue();
                if (((((Number)left).longValue() ^ ((Number)right).longValue()) & (((Number)left).longValue() ^ result)) >= 0L) return result;
                throw new IntegerOverflow(left + " - " + right, null, 2, null);
            }
            if (left instanceof Double && right instanceof Double) {
                double d;
                Token.Operator.Binary.Sum sum = operator;
                if (sum instanceof Token.Operator.Binary.Sum.Plus) {
                    d = ((Number)left).doubleValue() + ((Number)right).doubleValue();
                } else {
                    if (!(sum instanceof Token.Operator.Binary.Sum.Minus)) throw new NoWhenBranchMatchedException();
                    d = ((Number)left).doubleValue() - ((Number)right).doubleValue();
                }
                object = d;
                return object;
            }
            EvaluableExceptionKt.throwExceptionOnEvaluationFailed(operator, left, right);
            throw new KotlinNothingValueException();
        }

        @NotNull
        public final Object evalFactor$div_evaluable(@NotNull Token.Operator.Binary.Factor operator, @NotNull Object left, @NotNull Object right) {
            Number number;
            block24: {
                block19: {
                    long l;
                    Token.Operator.Binary.Factor factor;
                    block20: {
                        long result;
                        block21: {
                            block23: {
                                block22: {
                                    long absRight;
                                    Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
                                    Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                                    Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                                    if (!(left instanceof Long) || !(right instanceof Long)) break block19;
                                    factor = operator;
                                    if (!(factor instanceof Token.Operator.Binary.Factor.Multiplication)) break block20;
                                    result = ((Number)left).longValue() * ((Number)right).longValue();
                                    long absLeft = Math.abs(((Number)left).longValue());
                                    if ((absLeft | (absRight = Math.abs(((Number)right).longValue()))) >>> 31 == 0L) break block21;
                                    if (Intrinsics.areEqual((Object)right, (Object)0L)) break block22;
                                    Object object = left;
                                    if (!(object instanceof Long) || result / ((Number)right).longValue() != ((Number)object).longValue()) break block23;
                                }
                                if (!Intrinsics.areEqual((Object)left, (Object)Long.MIN_VALUE) || !Intrinsics.areEqual((Object)right, (Object)-1L)) break block21;
                            }
                            throw new IntegerOverflow(left + " * " + right, null, 2, null);
                        }
                        return result;
                    }
                    if (factor instanceof Token.Operator.Binary.Factor.Division) {
                        if (Intrinsics.areEqual((Object)right, (Object)0L)) {
                            EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(left + " / " + right, "Division by zero is not supported.", null, 4, null);
                            throw new KotlinNothingValueException();
                        }
                        l = ((Number)left).longValue() / ((Number)right).longValue();
                    } else if (factor instanceof Token.Operator.Binary.Factor.Modulo) {
                        if (Intrinsics.areEqual((Object)right, (Object)0L)) {
                            EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(left + " % " + right, "Division by zero is not supported.", null, 4, null);
                            throw new KotlinNothingValueException();
                        }
                        l = ((Number)left).longValue() % ((Number)right).longValue();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    number = l;
                    break block24;
                }
                if (left instanceof Double && right instanceof Double) {
                    double d;
                    Token.Operator.Binary.Factor factor = operator;
                    if (factor instanceof Token.Operator.Binary.Factor.Multiplication) {
                        d = ((Number)left).doubleValue() * ((Number)right).doubleValue();
                    } else if (factor instanceof Token.Operator.Binary.Factor.Division) {
                        if (((Number)right).doubleValue() == 0.0) {
                            EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(left + " / " + right, "Division by zero is not supported.", null, 4, null);
                            throw new KotlinNothingValueException();
                        }
                        d = ((Number)left).doubleValue() / ((Number)right).doubleValue();
                    } else if (factor instanceof Token.Operator.Binary.Factor.Modulo) {
                        if (((Number)right).doubleValue() == 0.0) {
                            EvaluableExceptionKt.throwExceptionOnEvaluationFailed$default(left + " % " + right, "Division by zero is not supported.", null, 4, null);
                            throw new KotlinNothingValueException();
                        }
                        d = ((Number)left).doubleValue() % ((Number)right).doubleValue();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    number = d;
                } else {
                    EvaluableExceptionKt.throwExceptionOnEvaluationFailed(operator, left, right);
                    throw new KotlinNothingValueException();
                }
            }
            return number;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

