/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.evaluable.function;

import com.yandex.div.evaluable.EvaluableException;
import com.yandex.div.evaluable.EvaluableExceptionKt;
import com.yandex.div.evaluable.EvaluableType;
import com.yandex.div.evaluable.Function;
import com.yandex.div.evaluable.FunctionArgument;
import com.yandex.div.evaluable.FunctionProvider;
import com.yandex.div.evaluable.function.FunctionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016J\"\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0007J\u001e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/yandex/div/evaluable/function/FunctionRegistry;", "Lcom/yandex/div/evaluable/FunctionProvider;", "()V", "knownFunctions", "", "", "", "Lcom/yandex/div/evaluable/Function;", "ensureRegistered", "", "name", "args", "", "Lcom/yandex/div/evaluable/FunctionArgument;", "resultType", "Lcom/yandex/div/evaluable/EvaluableType;", "get", "getFunctionArgumentsException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "register", "function", "validateFunction", "overloadedFunctions", "div-evaluable"})
public final class FunctionRegistry
implements FunctionProvider {
    @NotNull
    private final Map<String, List<Function>> knownFunctions = new LinkedHashMap();

    /*
     * WARNING - void declaration
     */
    public final void register(@NotNull Function function) {
        List overloadedFunctions;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Map<String, List<Function>> map = this.knownFunctions;
        String key$iv = function.getName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if (!(overloadedFunctions = (List)object).contains(function)) {
            ((Collection)overloadedFunctions).add(this.validateFunction(function, overloadedFunctions));
        }
    }

    private final Function validateFunction(Function function, List<? extends Function> overloadedFunctions) {
        return FunctionValidator.INSTANCE.validateOverloading(FunctionValidator.INSTANCE.validateFunction(function), overloadedFunctions);
    }

    @Override
    @NotNull
    public Function get(@NotNull String name, @NotNull List<? extends EvaluableType> args) {
        Object v0;
        block8: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            List<Function> list = this.knownFunctions.get(name);
            if (list == null) {
                boolean bl = false;
                throw new EvaluableException("Unknown function name: " + name + '.', null, 2, null);
            }
            List<Function> overloadedFunctions = list;
            if (overloadedFunctions.size() == 1) {
                Function function = (Function)CollectionsKt.first(overloadedFunctions);
                Function.MatchResult result = function.matchesArguments$div_evaluable(args);
                if (result instanceof Function.MatchResult.Ok) {
                    return function;
                }
                if (result instanceof Function.MatchResult.TooFewArguments) {
                    throw new EvaluableException("Too few arguments passed to function '" + name + "': expected " + ((Function.MatchResult.TooFewArguments)result).getExpected() + ", got " + ((Function.MatchResult.TooFewArguments)result).getActual() + '.', null, 2, null);
                }
                if (result instanceof Function.MatchResult.TooManyArguments) {
                    throw new EvaluableException("Too many arguments passed to function '" + name + "': expected " + ((Function.MatchResult.TooManyArguments)result).getExpected() + ", got " + ((Function.MatchResult.TooManyArguments)result).getActual() + '.', null, 2, null);
                }
                if (result instanceof Function.MatchResult.ArgTypeMismatch) {
                    throw new EvaluableException("Call of function '" + name + "' has argument type mismatch: expected " + (Object)((Object)((Function.MatchResult.ArgTypeMismatch)result).getExpected()) + ", got " + (Object)((Object)((Function.MatchResult.ArgTypeMismatch)result).getActual()) + '.', null, 2, null);
                }
                throw new NoWhenBranchMatchedException();
            }
            for (Object t : (Iterable)overloadedFunctions) {
                Function function = (Function)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)function.matchesArguments$div_evaluable(args), (Object)Function.MatchResult.Ok.INSTANCE)) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        Function function = v0;
        if (function == null) {
            throw this.getFunctionArgumentsException(name, args);
        }
        return function;
    }

    private final Exception getFunctionArgumentsException(String name, List<? extends EvaluableType> args) {
        if (args.isEmpty()) {
            return new EvaluableException("Non empty argument list is required for function '" + name + "'.", null, 2, null);
        }
        return new EvaluableException("Function '" + name + "' has no matching override for given argument types: " + EvaluableExceptionKt.toMessageFormat(args) + '.', null, 2, null);
    }

    public final void ensureRegistered(@NotNull String name, @NotNull List<FunctionArgument> args, @NotNull EvaluableType resultType) {
        boolean bl;
        block10: {
            Function it;
            boolean bl2;
            boolean $i$f$none;
            Iterable $this$none$iv;
            List<Function> overloadedFunctions;
            block9: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Intrinsics.checkNotNullParameter((Object)((Object)resultType), (String)"resultType");
                List<Function> list = this.knownFunctions.get(name);
                if (list == null) {
                    boolean bl3 = false;
                    throw new EvaluableException("Unknown function name: '" + name + "'.", null, 2, null);
                }
                overloadedFunctions = list;
                $this$none$iv = overloadedFunctions;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (Function)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it.getDeclaredArgs(), args)) continue;
                        bl2 = false;
                        break block9;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                throw new EvaluableException("Function with declared args is not registered.", null, 2, null);
            }
            $this$none$iv = overloadedFunctions;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (Function)element$iv;
                    boolean bl5 = false;
                    if (!(it.getResultType() == resultType)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl) {
            throw new EvaluableException("Function with specified result type is not registered.", null, 2, null);
        }
    }
}

