/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.evaluable.function;

import com.yandex.div.evaluable.EvaluableException;
import com.yandex.div.evaluable.Function;
import com.yandex.div.evaluable.FunctionArgument;
import com.yandex.div.evaluable.function.FunctionValidatorKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u001c\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a8\u0006\n"}, d2={"Lcom/yandex/div/evaluable/function/FunctionValidator;", "", "()V", "validateFunction", "Lcom/yandex/div/evaluable/Function;", "function", "validateOverloading", "nonValidatedFunction", "overloadedFunctions", "", "div-evaluable"})
public final class FunctionValidator {
    @NotNull
    public static final FunctionValidator INSTANCE = new FunctionValidator();

    private FunctionValidator() {
    }

    @NotNull
    public final Function validateFunction(@NotNull Function function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        List<FunctionArgument> declaredArgs = function.getDeclaredArgs();
        int n = 0;
        int n2 = CollectionsKt.getLastIndex(declaredArgs);
        while (n < n2) {
            int index;
            FunctionArgument argument;
            if (!(argument = declaredArgs.get(index = n++)).isVariadic()) continue;
            throw new EvaluableException("Variadic argument allowed at the end of list only", null, 2, null);
        }
        return function;
    }

    @NotNull
    public final Function validateOverloading(@NotNull Function nonValidatedFunction, @NotNull List<? extends Function> overloadedFunctions) {
        Intrinsics.checkNotNullParameter((Object)nonValidatedFunction, (String)"nonValidatedFunction");
        Intrinsics.checkNotNullParameter(overloadedFunctions, (String)"overloadedFunctions");
        Iterable $this$forEach$iv = overloadedFunctions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function function = (Function)element$iv;
            boolean bl = false;
            if (!FunctionValidatorKt.access$conflictsWith(nonValidatedFunction, function)) continue;
            throw new EvaluableException("Function " + function + " has conflict with " + function, null, 2, null);
        }
        return nonValidatedFunction;
    }
}

