/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.evaluable.internal;

import com.yandex.div.evaluable.Evaluable;
import com.yandex.div.evaluable.EvaluableException;
import com.yandex.div.evaluable.internal.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/yandex/div/evaluable/internal/Parser;", "", "()V", "and", "Lcom/yandex/div/evaluable/Evaluable;", "state", "Lcom/yandex/div/evaluable/internal/Parser$ParsingState;", "call", "comparison", "equal", "exponent", "expression", "factor", "or", "parse", "tokens", "", "Lcom/yandex/div/evaluable/internal/Token;", "rawExpression", "", "sum", "unary", "ParsingState", "div-evaluable"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();

    private Parser() {
    }

    @NotNull
    public final Evaluable parse(@NotNull List<? extends Token> tokens, @NotNull String rawExpression) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)rawExpression, (String)"rawExpression");
        if (tokens.isEmpty()) {
            throw new EvaluableException("Expression expected", null, 2, null);
        }
        ParsingState state = new ParsingState(tokens, rawExpression);
        Evaluable expression = this.expression(state);
        if (state.isNotAtEnd()) {
            throw new EvaluableException("Expression expected", null, 2, null);
        }
        return expression;
    }

    private final Evaluable expression(ParsingState state) {
        Evaluable first = this.or(state);
        if (state.isNotAtEnd() && state.currentToken() instanceof Token.Operator.TernaryIf) {
            state.forward();
            Evaluable second = this.expression(state);
            if (!(state.currentToken() instanceof Token.Operator.TernaryElse)) {
                throw new EvaluableException("':' expected in ternary-if-else expression", null, 2, null);
            }
            state.forward();
            Evaluable third = this.expression(state);
            return new Evaluable.Ternary(Token.Operator.TernaryIfElse.INSTANCE, first, second, third, state.getRawExpr());
        }
        return first;
    }

    private final Evaluable or(ParsingState state) {
        Evaluable left = this.and(state);
        while (state.isNotAtEnd() && state.currentToken() instanceof Token.Operator.Binary.Logical.Or) {
            state.forward();
            Evaluable right = this.and(state);
            left = new Evaluable.Binary(Token.Operator.Binary.Logical.Or.INSTANCE, left, right, state.getRawExpr());
        }
        return left;
    }

    private final Evaluable and(ParsingState state) {
        Evaluable left = this.equal(state);
        while (state.isNotAtEnd() && state.currentToken() instanceof Token.Operator.Binary.Logical.And) {
            state.forward();
            Evaluable right = this.equal(state);
            left = new Evaluable.Binary(Token.Operator.Binary.Logical.And.INSTANCE, left, right, state.getRawExpr());
        }
        return left;
    }

    private final Evaluable equal(ParsingState state) {
        Evaluable left = this.comparison(state);
        while (state.isNotAtEnd() && state.currentToken() instanceof Token.Operator.Binary.Equality) {
            Token operator = state.next();
            Evaluable right = this.comparison(state);
            left = new Evaluable.Binary((Token.Operator.Binary)operator, left, right, state.getRawExpr());
        }
        return left;
    }

    private final Evaluable comparison(ParsingState state) {
        Evaluable left = this.sum(state);
        while (state.isNotAtEnd() && state.currentToken() instanceof Token.Operator.Binary.Comparison) {
            Token operator = state.next();
            Evaluable right = this.sum(state);
            left = new Evaluable.Binary((Token.Operator.Binary)operator, left, right, state.getRawExpr());
        }
        return left;
    }

    private final Evaluable sum(ParsingState state) {
        Evaluable left = this.factor(state);
        while (state.isNotAtEnd() && state.currentToken() instanceof Token.Operator.Binary.Sum) {
            Token operator = state.next();
            left = new Evaluable.Binary((Token.Operator.Binary)operator, left, this.factor(state), state.getRawExpr());
        }
        return left;
    }

    private final Evaluable factor(ParsingState state) {
        Evaluable left = this.unary(state);
        while (state.isNotAtEnd() && state.currentToken() instanceof Token.Operator.Binary.Factor) {
            Token operator = state.next();
            left = new Evaluable.Binary((Token.Operator.Binary)operator, left, this.unary(state), state.getRawExpr());
        }
        return left;
    }

    private final Evaluable unary(ParsingState state) {
        Evaluable evaluable;
        if (state.isNotAtEnd() && state.currentToken() instanceof Token.Operator.Unary) {
            Token token = state.next();
            evaluable = new Evaluable.Unary((Token.Operator)token, this.unary(state), state.getRawExpr());
        } else {
            evaluable = this.exponent(state);
        }
        return evaluable;
    }

    private final Evaluable exponent(ParsingState state) {
        Evaluable call = this.call(state);
        if (state.isNotAtEnd() && state.currentToken() instanceof Token.Operator.Binary.Power) {
            state.forward();
            call = new Evaluable.Binary(Token.Operator.Binary.Power.INSTANCE, call, this.unary(state), state.getRawExpr());
        }
        return call;
    }

    private final Evaluable call(ParsingState state) {
        Evaluable evaluable;
        if (state.isAtEnd()) {
            throw new EvaluableException("Expression expected", null, 2, null);
        }
        Token token = state.next();
        if (token instanceof Token.Operand.Literal) {
            evaluable = new Evaluable.Value((Token.Operand.Literal)token, state.getRawExpr());
        } else if (token instanceof Token.Operand.Variable) {
            evaluable = new Evaluable.Variable(((Token.Operand.Variable)token).unbox-impl(), state.getRawExpr(), null);
        } else if (token instanceof Token.Function) {
            if (!(state.next() instanceof Token.Bracket.LeftRound)) {
                throw new EvaluableException("'(' expected after function call", null, 2, null);
            }
            List arguments = new ArrayList();
            while (!(state.currentToken() instanceof Token.Bracket.RightRound)) {
                ((Collection)arguments).add(this.expression(state));
                if (!(state.currentToken() instanceof Token.Function.ArgumentDelimiter)) continue;
                state.forward();
            }
            if (!(state.next() instanceof Token.Bracket.RightRound)) {
                throw new EvaluableException("expected ')' after a function call", null, 2, null);
            }
            evaluable = new Evaluable.FunctionCall((Token.Function)token, arguments, state.getRawExpr());
        } else if (token instanceof Token.Bracket.LeftRound) {
            Evaluable result = this.expression(state);
            if (!(state.next() instanceof Token.Bracket.RightRound)) {
                throw new EvaluableException("')' expected after expression", null, 2, null);
            }
            evaluable = result;
        } else if (token instanceof Token.StringTemplate.Start) {
            List arguments = new ArrayList();
            while (state.isNotAtEnd() && !(state.currentToken() instanceof Token.StringTemplate.End)) {
                if (state.currentToken() instanceof Token.StringTemplate.StartOfExpression || state.currentToken() instanceof Token.StringTemplate.EndOfExpression) {
                    state.forward();
                    continue;
                }
                ((Collection)arguments).add(this.expression(state));
            }
            if (!(state.next() instanceof Token.StringTemplate.End)) {
                throw new EvaluableException("expected ''' at end of a string template", null, 2, null);
            }
            evaluable = new Evaluable.StringTemplate(arguments, state.getRawExpr());
        } else {
            throw new EvaluableException("Expression expected", null, 2, null);
        }
        return evaluable;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0006\u0010\u0013\u001a\u00020\u0004J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0017\u001a\u00020\tJ\t\u0010\u0018\u001a\u00020\tH\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u0015J\u0006\u0010\u001a\u001a\u00020\u0015J\u0006\u0010\u001b\u001a\u00020\u0004J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/yandex/div/evaluable/internal/Parser$ParsingState;", "", "tokens", "", "Lcom/yandex/div/evaluable/internal/Token;", "rawExpr", "", "(Ljava/util/List;Ljava/lang/String;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "getRawExpr", "()Ljava/lang/String;", "component1", "component2", "copy", "currentToken", "equals", "", "other", "forward", "hashCode", "isAtEnd", "isNotAtEnd", "next", "toString", "div-evaluable"})
    private static final class ParsingState {
        @NotNull
        private final List<Token> tokens;
        @NotNull
        private final String rawExpr;
        private int index;

        public ParsingState(@NotNull List<? extends Token> tokens, @NotNull String rawExpr) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)rawExpr, (String)"rawExpr");
            this.tokens = tokens;
            this.rawExpr = rawExpr;
        }

        @NotNull
        public final String getRawExpr() {
            return this.rawExpr;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @NotNull
        public final Token currentToken() {
            return this.tokens.get(this.index);
        }

        @NotNull
        public final Token next() {
            return this.tokens.get(this.forward());
        }

        public final int forward() {
            int n = this.index;
            this.index = n + 1;
            return n;
        }

        public final boolean isNotAtEnd() {
            return !this.isAtEnd();
        }

        public final boolean isAtEnd() {
            return this.index >= this.tokens.size();
        }

        private final List<Token> component1() {
            return this.tokens;
        }

        @NotNull
        public final String component2() {
            return this.rawExpr;
        }

        @NotNull
        public final ParsingState copy(@NotNull List<? extends Token> tokens, @NotNull String rawExpr) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)rawExpr, (String)"rawExpr");
            return new ParsingState(tokens, rawExpr);
        }

        public static /* synthetic */ ParsingState copy$default(ParsingState parsingState, List list, String string, int n, Object object) {
            if ((n & 1) != 0) {
                list = parsingState.tokens;
            }
            if ((n & 2) != 0) {
                string = parsingState.rawExpr;
            }
            return parsingState.copy(list, string);
        }

        @NotNull
        public String toString() {
            return "ParsingState(tokens=" + this.tokens + ", rawExpr=" + this.rawExpr + ')';
        }

        public int hashCode() {
            int result = ((Object)this.tokens).hashCode();
            result = result * 31 + this.rawExpr.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsingState)) {
                return false;
            }
            ParsingState parsingState = (ParsingState)other;
            if (!Intrinsics.areEqual(this.tokens, parsingState.tokens)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rawExpr, (Object)parsingState.rawExpr);
        }
    }
}

