/*
 * Decompiled with CFR 0.152.
 */
package de.topobyte.osm4j.core.access.wrapper;

import de.topobyte.osm4j.core.access.OsmElementCounter;
import de.topobyte.osm4j.core.access.OsmIterator;
import de.topobyte.osm4j.core.model.iface.EntityContainer;
import de.topobyte.osm4j.core.model.iface.EntityType;

public class OsmElementCounterIteratorAdapter
implements OsmElementCounter {
    private OsmIterator iterator;
    private int numNodes = 0;
    private int numWays = 0;
    private int numRelations = 0;

    public OsmElementCounterIteratorAdapter(OsmIterator iterator) {
        this.iterator = iterator;
    }

    @Override
    public void count() {
        while (this.iterator.hasNext()) {
            EntityContainer container = (EntityContainer)this.iterator.next();
            switch (container.getType()) {
                case Node: {
                    ++this.numNodes;
                    break;
                }
                case Way: {
                    ++this.numWays;
                    break;
                }
                case Relation: {
                    ++this.numRelations;
                }
            }
        }
    }

    @Override
    public long getNumberOfNodes() {
        return this.numNodes;
    }

    @Override
    public long getNumberOfWays() {
        return this.numWays;
    }

    @Override
    public long getNumberOfRelations() {
        return this.numRelations;
    }

    @Override
    public long getTotalNumberOfElements() {
        return this.numNodes + this.numWays + this.numRelations;
    }

    @Override
    public long getNumberOfElements(EntityType type) {
        switch (type) {
            default: {
                return 0L;
            }
            case Node: {
                return this.numNodes;
            }
            case Way: {
                return this.numWays;
            }
            case Relation: 
        }
        return this.numRelations;
    }
}

