/*
 * Decompiled with CFR 0.152.
 */
package dk.ilios.realmfieldnames;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dk.ilios.realmfieldnames.ClassData;
import dk.ilios.realmfieldnames.FieldNameFormatter;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;

public class FileGenerator {
    private final Filer filer;
    private final FieldNameFormatter formatter;

    public FileGenerator(Filer filer) {
        this.filer = filer;
        this.formatter = new FieldNameFormatter();
    }

    public boolean generate(Set<ClassData> fileData) {
        for (ClassData classData : fileData) {
            if (this.generateFile(classData)) continue;
            return false;
        }
        return true;
    }

    private boolean generateFile(ClassData classData) {
        TypeSpec.Builder fileBuilder = TypeSpec.classBuilder((String)(classData.getSimpleClassName() + "Fields")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("This class enumerate all queryable fields in $S.$S", new Object[]{classData.getPackageName(), classData.getSimpleClassName()});
        for (String fieldName : classData.getFields()) {
            FieldSpec field = FieldSpec.builder(String.class, (String)this.formatter.format(fieldName), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{fieldName}).build();
            fileBuilder.addField(field);
        }
        JavaFile javaFile = JavaFile.builder((String)classData.getPackageName(), (TypeSpec)fileBuilder.build()).build();
        try {
            javaFile.writeTo(this.filer);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

