/*
 * Decompiled with CFR 0.152.
 */
package dk.ilios.realmfieldnames;

import dk.ilios.realmfieldnames.ClassData;
import dk.ilios.realmfieldnames.FileGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.realm.annotations.RealmClass"})
public class RealmFieldNamesProcessor
extends AbstractProcessor {
    private static final boolean CONSUME_ANNOTATIONS = false;
    private Set<ClassData> classes = new HashSet<ClassData>();
    private Types typeUtils;
    private Messager messager;
    private TypeMirror ignoreAnnotation;
    private FileGenerator fileGenerator;
    private boolean done = false;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        Elements elementUtils = processingEnv.getElementUtils();
        this.ignoreAnnotation = elementUtils.getTypeElement("io.realm.annotations.Ignore").asType();
        this.fileGenerator = new FileGenerator(processingEnv.getFiler());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.done) {
            return false;
        }
        TypeElement realmClassAnnotation = annotations.iterator().next();
        for (Element element : roundEnv.getElementsAnnotatedWith(realmClassAnnotation)) {
            ClassData classData = this.processClass((TypeElement)element);
            this.classes.add(classData);
        }
        this.done = this.fileGenerator.generate(this.classes);
        return false;
    }

    private ClassData processClass(TypeElement classElement) {
        String packageName = this.getPackageName(classElement);
        String className = classElement.getSimpleName().toString();
        ClassData data = new ClassData(packageName, className);
        for (Element element : classElement.getEnclosedElements()) {
            VariableElement variableElement;
            Set<Modifier> modifiers;
            ElementKind elementKind = element.getKind();
            if (!elementKind.equals((Object)ElementKind.FIELD) || (modifiers = (variableElement = (VariableElement)element).getModifiers()).contains((Object)Modifier.STATIC)) continue;
            List<? extends AnnotationMirror> elementAnnotations = variableElement.getAnnotationMirrors();
            boolean ignoreField = false;
            for (AnnotationMirror annotationMirror : elementAnnotations) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                if (!this.typeUtils.isAssignable(annotationType, this.ignoreAnnotation)) continue;
                ignoreField = true;
                break;
            }
            if (ignoreField) continue;
            data.addField(element.getSimpleName().toString());
        }
        return data;
    }

    private String getPackageName(TypeElement classElement) {
        Element enclosingElement = classElement.getEnclosingElement();
        if (!enclosingElement.getKind().equals((Object)ElementKind.PACKAGE)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Could not determine the package name. Enclosing element was: " + (Object)((Object)enclosingElement.getKind()));
            return null;
        }
        PackageElement packageElement = (PackageElement)enclosingElement;
        return packageElement.getQualifiedName().toString();
    }
}

