//
//  SMAMoPubSmaatoNativeCustomEvent.h
//  SmaatoSDKAdapters
//
//  Created by muhammad on 30.01.20.
//  Copyright © 2020 Smaato. All rights reserved.
//

#if __has_include("MoPub/MoPub.h")
#import "MoPub/MoPub.h"
#else
#import <mopub-ios-sdk/MoPub.h>
#endif

#import <SmaatoSDKNative/SmaatoSDKNative.h>

@interface SMAMoPubSmaatoNativeCustomEvent : NSObject <MPNativeAdAdapter, SMANativeAdDelegate>

/**
 Unavailable.
 Use \c initWithNativeAd: to create instances of \c SMAMoPubSmaatoNativeCustomEvent class.
 */
- (instancetype)init NS_UNAVAILABLE;

/**
 Designated initializer. Creates instance of \c SMAMoPubSmaatoNativeCustomEvent
 class with the provided \c SMANativeAdAssets .

 @param nativeAd The native ad renderer object that should be retained if there is an intention to receive the
                 callbacks about ad life cycle
 @param nativeAdRenderer The native ad renderer object
 @return The initialized \c SMAMoPubSmaatoNativeCustomEvent
 */
- (instancetype)initWithNativeAd:(SMANativeAd *)nativeAd adRenderer:(SMANativeAdRenderer *)nativeAdRenderer NS_DESIGNATED_INITIALIZER;

@end
