/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.bip32.Index;

final class Derivation<T> {
    private final Visitor<T> visitor;

    Derivation(Visitor<T> visitor) {
        this.visitor = visitor;
    }

    T derive(T startAt, CharSequence derivationPath) {
        int length = derivationPath.length();
        if (length == 1) {
            return startAt;
        }
        T current = startAt;
        int buffer = 0;
        block4: for (int i = 2; i < length; ++i) {
            char c = derivationPath.charAt(i);
            switch (c) {
                case '\'': {
                    buffer = Index.hard(buffer);
                    continue block4;
                }
                case '/': {
                    current = this.visitor.visit(current, buffer);
                    buffer = 0;
                    continue block4;
                }
                default: {
                    buffer *= 10;
                    buffer += c - 48;
                }
            }
        }
        return this.visitor.visit(current, buffer);
    }

    static interface Visitor<T> {
        public T visit(T var1, int var2);
    }
}

