/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.bip32.BigIntegerUtils;
import io.github.novacrypto.bip32.Hash160;
import io.github.novacrypto.bip32.Network;
import io.github.novacrypto.bip32.Secp256k1BC;
import io.github.novacrypto.bip32.Serializer;

final class HdKey {
    private final boolean neutered;
    private final Network network;
    private final byte[] chainCode;
    private final byte[] key;
    private final Serializer serializer;
    private final int parentFingerprint;
    private final int childNumber;
    private final int depth;

    private HdKey(Builder builder) {
        this.neutered = builder.neutered;
        this.network = builder.network;
        this.key = builder.key;
        this.parentFingerprint = builder.parentFingerprint;
        this.childNumber = builder.childNumber;
        this.chainCode = builder.chainCode;
        this.depth = builder.depth;
        this.serializer = new Serializer.Builder().network(builder.network).neutered(builder.neutered).depth(builder.depth).childNumber(builder.childNumber).fingerprint(builder.parentFingerprint).build();
    }

    byte[] serialize() {
        return this.serializer.serialize(this.key, this.chainCode);
    }

    byte[] getPoint() {
        return Secp256k1BC.pointSerP(BigIntegerUtils.parse256(this.key));
    }

    byte[] getKey() {
        return this.key;
    }

    int getParentFingerprint() {
        return this.parentFingerprint;
    }

    int calculateFingerPrint() {
        byte[] point = this.getPublicBuffer();
        byte[] o = Hash160.hash160(point);
        return (o[0] & 0xFF) << 24 | (o[1] & 0xFF) << 16 | (o[2] & 0xFF) << 8 | o[3] & 0xFF;
    }

    private byte[] getPublicBuffer() {
        return this.neutered ? this.key : this.getPoint();
    }

    int depth() {
        return this.depth;
    }

    public Network getNetwork() {
        return this.network;
    }

    byte[] getChainCode() {
        return this.chainCode;
    }

    int getChildNumber() {
        return this.childNumber;
    }

    static class Builder {
        private Network network;
        private boolean neutered;
        private byte[] chainCode;
        private byte[] key;
        private int depth;
        private int childNumber;
        private int parentFingerprint;

        Builder() {
        }

        Builder network(Network network) {
            this.network = network;
            return this;
        }

        Builder neutered(boolean neutered) {
            this.neutered = neutered;
            return this;
        }

        Builder key(byte[] key) {
            this.key = key;
            return this;
        }

        Builder chainCode(byte[] chainCode) {
            this.chainCode = chainCode;
            return this;
        }

        Builder depth(int depth) {
            this.depth = depth;
            return this;
        }

        Builder childNumber(int childNumber) {
            this.childNumber = childNumber;
            return this;
        }

        Builder parentFingerprint(int parentFingerprint) {
            this.parentFingerprint = parentFingerprint;
            return this;
        }

        HdKey build() {
            return new HdKey(this);
        }
    }
}

