/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.bip32.BigIntegerUtils;
import io.github.novacrypto.bip32.ByteArrayWriter;
import io.github.novacrypto.bip32.CKDpriv;
import io.github.novacrypto.bip32.CKDpub;
import io.github.novacrypto.bip32.Derivation;
import io.github.novacrypto.bip32.HdKey;
import io.github.novacrypto.bip32.HmacSha512;
import io.github.novacrypto.bip32.Index;
import io.github.novacrypto.bip32.Network;
import io.github.novacrypto.bip32.PublicKey;
import io.github.novacrypto.bip32.Secp256k1BC;
import io.github.novacrypto.bip32.ToByteArray;
import io.github.novacrypto.toruntime.CheckedExceptionToRuntime;
import java.math.BigInteger;
import java.util.Arrays;

public final class PrivateKey
implements CKDpriv,
CKDpub,
ToByteArray {
    private static final Derivation<PrivateKey> DERIVATION = new Derivation<PrivateKey>(new Derivation.Visitor<PrivateKey>(){

        @Override
        public PrivateKey visit(PrivateKey parent, int childIndex) {
            return parent.cKDpriv(childIndex);
        }
    });
    private static final byte[] BITCOIN_SEED = PrivateKey.getBytes("Bitcoin seed");
    private final HdKey hdKey;

    private PrivateKey(Network network, byte[] key, byte[] chainCode) {
        this(new HdKey.Builder().network(network).neutered(false).key(key).chainCode(chainCode).depth(0).childNumber(0).parentFingerprint(0).build());
    }

    private PrivateKey(HdKey hdKey) {
        this.hdKey = hdKey;
    }

    public static PrivateKey fromSeed(byte[] seed, Network network) {
        byte[] I = HmacSha512.hmacSha512(BITCOIN_SEED, seed);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        return new PrivateKey(network, Il, Ir);
    }

    private static byte[] getBytes(final String seed) {
        return (byte[])CheckedExceptionToRuntime.toRuntime((CheckedExceptionToRuntime.Func)new CheckedExceptionToRuntime.Func<byte[]>(){

            public byte[] run() throws Exception {
                return seed.getBytes("UTF-8");
            }
        });
    }

    @Override
    public byte[] toByteArray() {
        return this.hdKey.serialize();
    }

    @Override
    public PrivateKey cKDpriv(int index) {
        byte[] data = new byte[37];
        ByteArrayWriter writer = new ByteArrayWriter(data);
        if (Index.hardened(index)) {
            writer.concat((byte)0);
            writer.concat(this.hdKey.getKey(), 32);
        } else {
            writer.concat(this.hdKey.getPoint());
        }
        writer.concatSer32(index);
        byte[] I = HmacSha512.hmacSha512(this.hdKey.getChainCode(), data);
        Arrays.fill(data, (byte)0);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        byte[] key = this.hdKey.getKey();
        BigInteger mod = BigIntegerUtils.parse256(Il).add(BigIntegerUtils.parse256(key)).mod(Secp256k1BC.n());
        BigIntegerUtils.ser256(Il, mod);
        return new PrivateKey(new HdKey.Builder().network(this.hdKey.getNetwork()).neutered(false).key(Il).chainCode(Ir).depth(this.hdKey.depth() + 1).childNumber(index).parentFingerprint(this.hdKey.calculateFingerPrint()).build());
    }

    @Override
    public PublicKey cKDpub(int index) {
        return this.cKDpriv(index).neuter();
    }

    public PublicKey neuter() {
        return PublicKey.from(this.hdKey);
    }

    public PrivateKey derive(CharSequence derivationPath) {
        return DERIVATION.derive(this, derivationPath);
    }
}

