/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.bip32.BigIntegerUtils;
import io.github.novacrypto.bip32.ByteArrayWriter;
import io.github.novacrypto.bip32.CKDpub;
import io.github.novacrypto.bip32.HdKey;
import io.github.novacrypto.bip32.HmacSha512;
import io.github.novacrypto.bip32.IllegalCKDCall;
import io.github.novacrypto.bip32.Index;
import io.github.novacrypto.bip32.Secp256k1BC;
import io.github.novacrypto.bip32.ToByteArray;

public final class PublicKey
implements CKDpub,
ToByteArray {
    private final HdKey hdKey;

    static PublicKey from(HdKey hdKey) {
        return new PublicKey(new HdKey.Builder().network(hdKey.getNetwork()).neutered(true).key(hdKey.getPoint()).parentFingerprint(hdKey.getParentFingerprint()).depth(hdKey.depth()).childNumber(hdKey.getChildNumber()).chainCode(hdKey.getChainCode()).build());
    }

    private PublicKey(HdKey hdKey) {
        this.hdKey = hdKey;
    }

    @Override
    public PublicKey cKDpub(int index) {
        if (Index.hardened(index)) {
            throw new IllegalCKDCall("Cannot derive a hardened key from a public key");
        }
        HdKey parent = this.hdKey;
        byte[] kPar = parent.getKey();
        byte[] data = new byte[37];
        ByteArrayWriter writer = new ByteArrayWriter(data);
        writer.concat(kPar, 33);
        writer.concatSer32(index);
        byte[] I = HmacSha512.hmacSha512(parent.getChainCode(), data);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        byte[] key = Secp256k1BC.pointSerP(BigIntegerUtils.parse256(Il), kPar);
        return new PublicKey(new HdKey.Builder().network(parent.getNetwork()).neutered(true).depth(parent.depth() + 1).parentFingerprint(parent.calculateFingerPrint()).key(key).chainCode(Ir).childNumber(index).build());
    }

    @Override
    public byte[] toByteArray() {
        return this.hdKey.serialize();
    }
}

