/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.bip32.BadKeySerializationException;
import io.github.novacrypto.hashing.Sha256;

final class Checksum {
    Checksum() {
    }

    static void confirmExtendedKeyChecksum(byte[] extendedKeyData) {
        byte[] expected = Checksum.checksum(extendedKeyData);
        for (int i = 0; i < 4; ++i) {
            if (extendedKeyData[78 + i] == expected[i]) continue;
            throw new BadKeySerializationException("Checksum error");
        }
    }

    static byte[] checksum(byte[] privateKey) {
        return Sha256.sha256Twice((byte[])privateKey, (int)0, (int)78);
    }
}

