/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.base58.Base58;
import io.github.novacrypto.bip32.BigIntegerUtils;
import io.github.novacrypto.bip32.ByteArrayWriter;
import io.github.novacrypto.bip32.CKDpriv;
import io.github.novacrypto.bip32.CKDpub;
import io.github.novacrypto.bip32.Deserializer;
import io.github.novacrypto.bip32.ExtendedKey;
import io.github.novacrypto.bip32.HdKey;
import io.github.novacrypto.bip32.HmacSha512;
import io.github.novacrypto.bip32.Index;
import io.github.novacrypto.bip32.Network;
import io.github.novacrypto.bip32.Networks;
import io.github.novacrypto.bip32.PrivateKeyDeserializer;
import io.github.novacrypto.bip32.PublicKey;
import io.github.novacrypto.bip32.Secp256k1BC;
import io.github.novacrypto.bip32.derivation.CkdFunction;
import io.github.novacrypto.bip32.derivation.CkdFunctionDerive;
import io.github.novacrypto.bip32.derivation.CkdFunctionResultCacheDecorator;
import io.github.novacrypto.bip32.derivation.Derivation;
import io.github.novacrypto.bip32.derivation.Derive;
import io.github.novacrypto.toruntime.CheckedExceptionToRuntime;
import java.math.BigInteger;
import java.util.Arrays;

public final class PrivateKey
implements Derive<PrivateKey>,
CKDpriv,
CKDpub,
ExtendedKey {
    private static final CkdFunction<PrivateKey> CKD_FUNCTION = new CkdFunction<PrivateKey>(){

        public PrivateKey deriveChildKey(PrivateKey parent, int childIndex) {
            return parent.cKDpriv(childIndex);
        }
    };
    private static final byte[] BITCOIN_SEED = PrivateKey.getBytes("Bitcoin seed");
    private final HdKey hdKey;

    public static Deserializer<PrivateKey> deserializer() {
        return PrivateKeyDeserializer.DEFAULT;
    }

    public static Deserializer<PrivateKey> deserializer(Networks networks) {
        return new PrivateKeyDeserializer(networks);
    }

    private PrivateKey(Network network, byte[] key, byte[] chainCode) {
        this(new HdKey.Builder().network(network).neutered(false).key(key).chainCode(chainCode).depth(0).childNumber(0).parentFingerprint(0).build());
    }

    PrivateKey(HdKey hdKey) {
        this.hdKey = hdKey;
    }

    public static PrivateKey fromSeed(byte[] seed, Network network) {
        byte[] I = HmacSha512.hmacSha512(BITCOIN_SEED, seed);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        return new PrivateKey(network, Il, Ir);
    }

    private static byte[] getBytes(final String seed) {
        return (byte[])CheckedExceptionToRuntime.toRuntime((CheckedExceptionToRuntime.Func)new CheckedExceptionToRuntime.Func<byte[]>(){

            public byte[] run() throws Exception {
                return seed.getBytes("UTF-8");
            }
        });
    }

    @Override
    public byte[] extendedKeyByteArray() {
        return this.hdKey.serialize();
    }

    @Override
    public String extendedBase58() {
        return Base58.base58Encode((byte[])this.extendedKeyByteArray());
    }

    @Override
    public PrivateKey cKDpriv(int index) {
        byte[] data = new byte[37];
        ByteArrayWriter writer = new ByteArrayWriter(data);
        if (Index.isHardened((int)index)) {
            writer.concat((byte)0);
            writer.concat(this.hdKey.getKey(), 32);
        } else {
            writer.concat(this.hdKey.getPoint());
        }
        writer.concatSer32(index);
        byte[] I = HmacSha512.hmacSha512(this.hdKey.getChainCode(), data);
        Arrays.fill(data, (byte)0);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        byte[] key = this.hdKey.getKey();
        BigInteger mod = BigIntegerUtils.parse256(Il).add(BigIntegerUtils.parse256(key)).mod(Secp256k1BC.n());
        BigIntegerUtils.ser256(Il, mod);
        return new PrivateKey(new HdKey.Builder().network(this.hdKey.getNetwork()).neutered(false).key(Il).chainCode(Ir).depth(this.hdKey.depth() + 1).childNumber(index).parentFingerprint(this.hdKey.calculateFingerPrint()).build());
    }

    @Override
    public PublicKey cKDpub(int index) {
        return this.cKDpriv(index).neuter();
    }

    public PublicKey neuter() {
        return PublicKey.from(this.hdKey);
    }

    public Derive<PrivateKey> derive() {
        return this.derive(CKD_FUNCTION);
    }

    public Derive<PrivateKey> deriveWithCache() {
        return this.derive((CkdFunction<PrivateKey>)CkdFunctionResultCacheDecorator.newCacheOf(CKD_FUNCTION));
    }

    public PrivateKey derive(CharSequence derivationPath) {
        return (PrivateKey)this.derive().derive(derivationPath);
    }

    public <Path> PrivateKey derive(Path derivationPath, Derivation<Path> derivation) {
        return (PrivateKey)this.derive().derive(derivationPath, derivation);
    }

    private Derive<PrivateKey> derive(CkdFunction<PrivateKey> ckdFunction) {
        return new CkdFunctionDerive(ckdFunction, (Object)this);
    }
}

