/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.base58.Base58;
import io.github.novacrypto.bip32.BadKeySerializationException;
import io.github.novacrypto.bip32.ByteArrayReader;
import io.github.novacrypto.bip32.Checksum;
import io.github.novacrypto.bip32.Deserializer;
import io.github.novacrypto.bip32.HdKey;
import io.github.novacrypto.bip32.Networks;
import io.github.novacrypto.bip32.PrivateKey;
import io.github.novacrypto.bip32.networks.DefaultNetworks;
import java.util.Arrays;

final class PrivateKeyDeserializer
implements Deserializer<PrivateKey> {
    static final PrivateKeyDeserializer DEFAULT = new PrivateKeyDeserializer(DefaultNetworks.INSTANCE);
    private final Networks networks;

    PrivateKeyDeserializer(Networks networks) {
        this.networks = networks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrivateKey deserialize(CharSequence extendedBase58Key) {
        byte[] extendedKeyData = Base58.base58Decode((CharSequence)extendedBase58Key);
        try {
            PrivateKey privateKey = this.deserialize(extendedKeyData);
            return privateKey;
        }
        finally {
            Arrays.fill(extendedKeyData, (byte)0);
        }
    }

    @Override
    public PrivateKey deserialize(byte[] extendedKeyData) {
        Checksum.confirmExtendedKeyChecksum(extendedKeyData);
        ByteArrayReader reader = new ByteArrayReader(extendedKeyData);
        return new PrivateKey(new HdKey.Builder().network(this.networks.findByPrivateVersion(reader.readSer32())).depth(reader.read()).parentFingerprint(reader.readSer32()).childNumber(reader.readSer32()).chainCode(reader.readRange(32)).key(this.getKey(reader)).neutered(false).build());
    }

    private byte[] getKey(ByteArrayReader reader) {
        if (reader.read() != 0) {
            throw new BadKeySerializationException("Expected 0 padding at position 45");
        }
        return reader.readRange(32);
    }
}

