/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.base58.Base58;
import io.github.novacrypto.bip32.BigIntegerUtils;
import io.github.novacrypto.bip32.ByteArrayWriter;
import io.github.novacrypto.bip32.CKDpub;
import io.github.novacrypto.bip32.Deserializer;
import io.github.novacrypto.bip32.ExtendedKey;
import io.github.novacrypto.bip32.HdKey;
import io.github.novacrypto.bip32.HmacSha512;
import io.github.novacrypto.bip32.IllegalCKDCall;
import io.github.novacrypto.bip32.Index;
import io.github.novacrypto.bip32.Networks;
import io.github.novacrypto.bip32.PublicKeyDeserializer;
import io.github.novacrypto.bip32.Secp256k1BC;
import io.github.novacrypto.bip32.derivation.CkdFunction;
import io.github.novacrypto.bip32.derivation.CkdFunctionDerive;
import io.github.novacrypto.bip32.derivation.CkdFunctionResultCacheDecorator;
import io.github.novacrypto.bip32.derivation.Derivation;
import io.github.novacrypto.bip32.derivation.Derive;
import io.github.novacrypto.hashing.Hash160;
import io.github.novacrypto.hashing.Sha256;

public final class PublicKey
implements Derive<PublicKey>,
CKDpub,
ExtendedKey {
    private static final CkdFunction<PublicKey> CKD_FUNCTION = new CkdFunction<PublicKey>(){

        public PublicKey deriveChildKey(PublicKey parent, int childIndex) {
            return parent.cKDpub(childIndex);
        }
    };
    private final HdKey hdKey;

    public static Deserializer<PublicKey> deserializer() {
        return PublicKeyDeserializer.DEFAULT;
    }

    public static Deserializer<PublicKey> deserializer(Networks networks) {
        return new PublicKeyDeserializer(networks);
    }

    static PublicKey from(HdKey hdKey) {
        return new PublicKey(new HdKey.Builder().network(hdKey.getNetwork()).neutered(true).key(hdKey.getPoint()).parentFingerprint(hdKey.getParentFingerprint()).depth(hdKey.depth()).childNumber(hdKey.getChildNumber()).chainCode(hdKey.getChainCode()).build());
    }

    PublicKey(HdKey hdKey) {
        this.hdKey = hdKey;
    }

    @Override
    public PublicKey cKDpub(int index) {
        if (Index.isHardened((int)index)) {
            throw new IllegalCKDCall("Cannot derive a hardened key from a public key");
        }
        HdKey parent = this.hdKey;
        byte[] kPar = parent.getKey();
        byte[] data = new byte[37];
        ByteArrayWriter writer = new ByteArrayWriter(data);
        writer.concat(kPar, 33);
        writer.concatSer32(index);
        byte[] I = HmacSha512.hmacSha512(parent.getChainCode(), data);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        byte[] key = Secp256k1BC.pointSerP(BigIntegerUtils.parse256(Il), kPar);
        return new PublicKey(new HdKey.Builder().network(parent.getNetwork()).neutered(true).depth(parent.depth() + 1).parentFingerprint(parent.calculateFingerPrint()).key(key).chainCode(Ir).childNumber(index).build());
    }

    @Override
    public byte[] extendedKeyByteArray() {
        return this.hdKey.serialize();
    }

    @Override
    public String extendedBase58() {
        return Base58.base58Encode((byte[])this.extendedKeyByteArray());
    }

    public String p2pkhAddress() {
        return PublicKey.encodeAddress(this.hdKey.getNetwork().p2pkhVersion(), this.hdKey.getKey());
    }

    public String p2shAddress() {
        byte[] script = new byte[22];
        script[1] = 20;
        Hash160.hash160into((byte[])script, (int)2, (byte[])this.hdKey.getKey());
        return PublicKey.encodeAddress(this.hdKey.getNetwork().p2shVersion(), script);
    }

    private static String encodeAddress(byte version, byte[] data) {
        byte[] address = new byte[25];
        address[0] = version;
        Hash160.hash160into((byte[])address, (int)1, (byte[])data);
        System.arraycopy(Sha256.sha256Twice((byte[])address, (int)0, (int)21), 0, address, 21, 4);
        return Base58.base58Encode((byte[])address);
    }

    public Derive<PublicKey> derive() {
        return this.derive(CKD_FUNCTION);
    }

    public Derive<PublicKey> deriveWithCache() {
        return this.derive((CkdFunction<PublicKey>)CkdFunctionResultCacheDecorator.newCacheOf(CKD_FUNCTION));
    }

    public PublicKey derive(CharSequence derivationPath) {
        return (PublicKey)this.derive().derive(derivationPath);
    }

    public <Path> PublicKey derive(Path derivationPath, Derivation<Path> derivation) {
        return (PublicKey)this.derive().derive(derivationPath, derivation);
    }

    private Derive<PublicKey> derive(CkdFunction<PublicKey> ckdFunction) {
        return new CkdFunctionDerive(ckdFunction, (Object)this);
    }
}

