/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import java.math.BigInteger;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.crypto.ec.CustomNamedCurves;

final class Secp256k1BC {
    private static final X9ECParameters CURVE = CustomNamedCurves.getByName((String)"secp256k1");

    Secp256k1BC() {
    }

    static BigInteger n() {
        return CURVE.getN();
    }

    static byte[] pointSerP(BigInteger p) {
        return CURVE.getG().multiply(p).getEncoded(true);
    }

    static byte[] pointSerP(BigInteger p, byte[] toAdd) {
        return CURVE.getG().multiply(p).add(CURVE.getCurve().decodePoint(toAdd)).getEncoded(true);
    }
}

