/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import java.util.Arrays;

final class ByteArrayWriter {
    private final byte[] bytes;
    private int idx = 0;

    ByteArrayWriter(byte[] target) {
        this.bytes = target;
    }

    void concat(byte[] bytesSource, int length) {
        System.arraycopy(bytesSource, 0, this.bytes, this.idx, length);
        this.idx += length;
    }

    void concat(byte[] bytesSource) {
        this.concat(bytesSource, bytesSource.length);
    }

    void concatSer32(int i) {
        this.concat((byte)(i >> 24));
        this.concat((byte)(i >> 16));
        this.concat((byte)(i >> 8));
        this.concat((byte)i);
    }

    void concat(byte b) {
        this.bytes[this.idx++] = b;
    }

    static byte[] tail32(byte[] bytes64) {
        byte[] ir = new byte[bytes64.length - 32];
        System.arraycopy(bytes64, 32, ir, 0, ir.length);
        return ir;
    }

    static byte[] head32(byte[] bytes64) {
        return Arrays.copyOf(bytes64, 32);
    }
}

