/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.base58.Base58;
import io.github.novacrypto.bip32.BigIntegerUtils;
import io.github.novacrypto.bip32.ByteArrayWriter;
import io.github.novacrypto.bip32.CKDpriv;
import io.github.novacrypto.bip32.CKDpub;
import io.github.novacrypto.bip32.Deserializer;
import io.github.novacrypto.bip32.ExtendedKey;
import io.github.novacrypto.bip32.ExtendedPrivateKeyDeserializer;
import io.github.novacrypto.bip32.ExtendedPublicKey;
import io.github.novacrypto.bip32.HdKey;
import io.github.novacrypto.bip32.HmacSha512;
import io.github.novacrypto.bip32.Index;
import io.github.novacrypto.bip32.Network;
import io.github.novacrypto.bip32.Networks;
import io.github.novacrypto.bip32.Secp256k1SC;
import io.github.novacrypto.bip32.derivation.CkdFunction;
import io.github.novacrypto.bip32.derivation.CkdFunctionDerive;
import io.github.novacrypto.bip32.derivation.CkdFunctionResultCacheDecorator;
import io.github.novacrypto.bip32.derivation.Derivation;
import io.github.novacrypto.bip32.derivation.Derive;
import io.github.novacrypto.toruntime.CheckedExceptionToRuntime;
import java.math.BigInteger;
import java.util.Arrays;

public final class ExtendedPrivateKey
implements Derive<ExtendedPrivateKey>,
CKDpriv,
CKDpub,
ExtendedKey {
    private static final CkdFunction<ExtendedPrivateKey> CKD_FUNCTION = new CkdFunction<ExtendedPrivateKey>(){

        public ExtendedPrivateKey deriveChildKey(ExtendedPrivateKey parent, int childIndex) {
            return parent.cKDpriv(childIndex);
        }
    };
    private static final byte[] BITCOIN_SEED = ExtendedPrivateKey.getBytes("Bitcoin seed");
    private final HdKey hdKey;

    public static Deserializer<ExtendedPrivateKey> deserializer() {
        return ExtendedPrivateKeyDeserializer.DEFAULT;
    }

    public static Deserializer<ExtendedPrivateKey> deserializer(Networks networks) {
        return new ExtendedPrivateKeyDeserializer(networks);
    }

    private ExtendedPrivateKey(Network network, byte[] key, byte[] chainCode) {
        this(new HdKey.Builder().network(network).neutered(false).key(key).chainCode(chainCode).depth(0).childNumber(0).parentFingerprint(0).build());
    }

    ExtendedPrivateKey(HdKey hdKey) {
        this.hdKey = hdKey;
    }

    public static ExtendedPrivateKey fromSeed(byte[] seed, Network network) {
        byte[] I = HmacSha512.hmacSha512(BITCOIN_SEED, seed);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        return new ExtendedPrivateKey(network, Il, Ir);
    }

    private static byte[] getBytes(final String seed) {
        return (byte[])CheckedExceptionToRuntime.toRuntime((CheckedExceptionToRuntime.Func)new CheckedExceptionToRuntime.Func<byte[]>(){

            public byte[] run() throws Exception {
                return seed.getBytes("UTF-8");
            }
        });
    }

    @Override
    public byte[] extendedKeyByteArray() {
        return this.hdKey.serialize();
    }

    @Override
    public ExtendedPrivateKey toNetwork(Network otherNetwork) {
        if (otherNetwork == this.network()) {
            return this;
        }
        return new ExtendedPrivateKey(this.hdKey.toBuilder().network(otherNetwork).build());
    }

    @Override
    public String extendedBase58() {
        return Base58.base58Encode((byte[])this.extendedKeyByteArray());
    }

    @Override
    public ExtendedPrivateKey cKDpriv(int index) {
        byte[] data = new byte[37];
        ByteArrayWriter writer = new ByteArrayWriter(data);
        if (Index.isHardened((int)index)) {
            writer.concat((byte)0);
            writer.concat(this.hdKey.getKey(), 32);
        } else {
            writer.concat(this.hdKey.getPoint());
        }
        writer.concatSer32(index);
        byte[] I = HmacSha512.hmacSha512(this.hdKey.getChainCode(), data);
        Arrays.fill(data, (byte)0);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        byte[] key = this.hdKey.getKey();
        BigInteger parse256_Il = BigIntegerUtils.parse256(Il);
        BigInteger ki = parse256_Il.add(BigIntegerUtils.parse256(key)).mod(Secp256k1SC.n());
        if (parse256_Il.compareTo(Secp256k1SC.n()) >= 0 || ki.equals(BigInteger.ZERO)) {
            return this.cKDpriv(index + 1);
        }
        BigIntegerUtils.ser256(Il, ki);
        return new ExtendedPrivateKey(new HdKey.Builder().network(this.hdKey.getNetwork()).neutered(false).key(Il).chainCode(Ir).depth(this.hdKey.depth() + 1).childNumber(index).parentFingerprint(this.hdKey.calculateFingerPrint()).build());
    }

    @Override
    public ExtendedPublicKey cKDpub(int index) {
        return this.cKDpriv(index).neuter();
    }

    public ExtendedPublicKey neuter() {
        return ExtendedPublicKey.from(this.hdKey);
    }

    public Derive<ExtendedPrivateKey> derive() {
        return this.derive(CKD_FUNCTION);
    }

    public Derive<ExtendedPrivateKey> deriveWithCache() {
        return this.derive((CkdFunction<ExtendedPrivateKey>)CkdFunctionResultCacheDecorator.newCacheOf(CKD_FUNCTION));
    }

    public ExtendedPrivateKey derive(CharSequence derivationPath) {
        return (ExtendedPrivateKey)this.derive().derive(derivationPath);
    }

    public <Path> ExtendedPrivateKey derive(Path derivationPath, Derivation<Path> derivation) {
        return (ExtendedPrivateKey)this.derive().derive(derivationPath, derivation);
    }

    private Derive<ExtendedPrivateKey> derive(CkdFunction<ExtendedPrivateKey> ckdFunction) {
        return new CkdFunctionDerive(ckdFunction, (Object)this);
    }

    @Override
    public Network network() {
        return this.hdKey.getNetwork();
    }

    @Override
    public int depth() {
        return this.hdKey.depth();
    }

    @Override
    public int childNumber() {
        return this.hdKey.getChildNumber();
    }
}

