/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.base58.Base58;
import io.github.novacrypto.bip32.BigIntegerUtils;
import io.github.novacrypto.bip32.ByteArrayWriter;
import io.github.novacrypto.bip32.CKDpub;
import io.github.novacrypto.bip32.Deserializer;
import io.github.novacrypto.bip32.ExtendedKey;
import io.github.novacrypto.bip32.ExtendedPublicKeyDeserializer;
import io.github.novacrypto.bip32.HdKey;
import io.github.novacrypto.bip32.HmacSha512;
import io.github.novacrypto.bip32.IllegalCKDCall;
import io.github.novacrypto.bip32.Index;
import io.github.novacrypto.bip32.Network;
import io.github.novacrypto.bip32.Networks;
import io.github.novacrypto.bip32.Secp256k1SC;
import io.github.novacrypto.bip32.derivation.CkdFunction;
import io.github.novacrypto.bip32.derivation.CkdFunctionDerive;
import io.github.novacrypto.bip32.derivation.CkdFunctionResultCacheDecorator;
import io.github.novacrypto.bip32.derivation.Derivation;
import io.github.novacrypto.bip32.derivation.Derive;
import io.github.novacrypto.hashing.Hash160;
import io.github.novacrypto.hashing.Sha256;
import java.math.BigInteger;
import org.spongycastle.math.ec.ECPoint;

public final class ExtendedPublicKey
implements Derive<ExtendedPublicKey>,
CKDpub,
ExtendedKey {
    private static final CkdFunction<ExtendedPublicKey> CKD_FUNCTION = new CkdFunction<ExtendedPublicKey>(){

        public ExtendedPublicKey deriveChildKey(ExtendedPublicKey parent, int childIndex) {
            return parent.cKDpub(childIndex);
        }
    };
    private final HdKey hdKey;

    public static Deserializer<ExtendedPublicKey> deserializer() {
        return ExtendedPublicKeyDeserializer.DEFAULT;
    }

    public static Deserializer<ExtendedPublicKey> deserializer(Networks networks) {
        return new ExtendedPublicKeyDeserializer(networks);
    }

    static ExtendedPublicKey from(HdKey hdKey) {
        return new ExtendedPublicKey(new HdKey.Builder().network(hdKey.getNetwork()).neutered(true).key(hdKey.getPoint()).parentFingerprint(hdKey.getParentFingerprint()).depth(hdKey.depth()).childNumber(hdKey.getChildNumber()).chainCode(hdKey.getChainCode()).build());
    }

    ExtendedPublicKey(HdKey hdKey) {
        this.hdKey = hdKey;
    }

    @Override
    public ExtendedPublicKey cKDpub(int index) {
        if (Index.isHardened((int)index)) {
            throw new IllegalCKDCall("Cannot derive a hardened key from a public key");
        }
        HdKey parent = this.hdKey;
        byte[] kPar = parent.getKey();
        byte[] data = new byte[37];
        ByteArrayWriter writer = new ByteArrayWriter(data);
        writer.concat(kPar, 33);
        writer.concatSer32(index);
        byte[] I = HmacSha512.hmacSha512(parent.getChainCode(), data);
        byte[] Il = ByteArrayWriter.head32(I);
        byte[] Ir = ByteArrayWriter.tail32(I);
        BigInteger parse256_Il = BigIntegerUtils.parse256(Il);
        ECPoint ki = Secp256k1SC.gMultiplyAndAddPoint(parse256_Il, kPar);
        if (parse256_Il.compareTo(Secp256k1SC.n()) >= 0 || ki.isInfinity()) {
            return this.cKDpub(index + 1);
        }
        byte[] key = Secp256k1SC.pointSerP(ki);
        return new ExtendedPublicKey(new HdKey.Builder().network(parent.getNetwork()).neutered(true).depth(parent.depth() + 1).parentFingerprint(parent.calculateFingerPrint()).key(key).chainCode(Ir).childNumber(index).build());
    }

    @Override
    public byte[] extendedKeyByteArray() {
        return this.hdKey.serialize();
    }

    @Override
    public ExtendedPublicKey toNetwork(Network otherNetwork) {
        if (otherNetwork == this.network()) {
            return this;
        }
        return new ExtendedPublicKey(this.hdKey.toBuilder().network(otherNetwork).build());
    }

    @Override
    public String extendedBase58() {
        return Base58.base58Encode((byte[])this.extendedKeyByteArray());
    }

    public String p2pkhAddress() {
        return ExtendedPublicKey.encodeAddress(this.hdKey.getNetwork().p2pkhVersion(), this.hdKey.getKey());
    }

    public String p2shAddress() {
        byte[] script = new byte[22];
        script[1] = 20;
        Hash160.hash160into((byte[])script, (int)2, (byte[])this.hdKey.getKey());
        return ExtendedPublicKey.encodeAddress(this.hdKey.getNetwork().p2shVersion(), script);
    }

    private static String encodeAddress(byte version, byte[] data) {
        byte[] address = new byte[25];
        address[0] = version;
        Hash160.hash160into((byte[])address, (int)1, (byte[])data);
        System.arraycopy(Sha256.sha256Twice((byte[])address, (int)0, (int)21), 0, address, 21, 4);
        return Base58.base58Encode((byte[])address);
    }

    public Derive<ExtendedPublicKey> derive() {
        return this.derive(CKD_FUNCTION);
    }

    public Derive<ExtendedPublicKey> deriveWithCache() {
        return this.derive((CkdFunction<ExtendedPublicKey>)CkdFunctionResultCacheDecorator.newCacheOf(CKD_FUNCTION));
    }

    public ExtendedPublicKey derive(CharSequence derivationPath) {
        return (ExtendedPublicKey)this.derive().derive(derivationPath);
    }

    public <Path> ExtendedPublicKey derive(Path derivationPath, Derivation<Path> derivation) {
        return (ExtendedPublicKey)this.derive().derive(derivationPath, derivation);
    }

    private Derive<ExtendedPublicKey> derive(CkdFunction<ExtendedPublicKey> ckdFunction) {
        return new CkdFunctionDerive(ckdFunction, (Object)this);
    }

    @Override
    public Network network() {
        return this.hdKey.getNetwork();
    }

    @Override
    public int depth() {
        return this.hdKey.depth();
    }

    @Override
    public int childNumber() {
        return this.hdKey.getChildNumber();
    }
}

