/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import io.github.novacrypto.base58.Base58;
import io.github.novacrypto.bip32.ByteArrayReader;
import io.github.novacrypto.bip32.Checksum;
import io.github.novacrypto.bip32.Deserializer;
import io.github.novacrypto.bip32.ExtendedPublicKey;
import io.github.novacrypto.bip32.HdKey;
import io.github.novacrypto.bip32.Networks;
import io.github.novacrypto.bip32.networks.DefaultNetworks;
import java.util.Arrays;

final class ExtendedPublicKeyDeserializer
implements Deserializer<ExtendedPublicKey> {
    static final ExtendedPublicKeyDeserializer DEFAULT = new ExtendedPublicKeyDeserializer(DefaultNetworks.INSTANCE);
    private final Networks networks;

    ExtendedPublicKeyDeserializer(Networks networks) {
        this.networks = networks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedPublicKey deserialize(CharSequence extendedBase58Key) {
        byte[] extendedKeyData = Base58.base58Decode((CharSequence)extendedBase58Key);
        try {
            ExtendedPublicKey extendedPublicKey = this.deserialize(extendedKeyData);
            return extendedPublicKey;
        }
        finally {
            Arrays.fill(extendedKeyData, (byte)0);
        }
    }

    @Override
    public ExtendedPublicKey deserialize(byte[] extendedKeyData) {
        Checksum.confirmExtendedKeyChecksum(extendedKeyData);
        ByteArrayReader reader = new ByteArrayReader(extendedKeyData);
        return new ExtendedPublicKey(new HdKey.Builder().network(this.networks.findByPublicVersion(reader.readSer32())).depth(reader.read()).parentFingerprint(reader.readSer32()).childNumber(reader.readSer32()).chainCode(reader.readRange(32)).key(reader.readRange(33)).neutered(true).build());
    }
}

