/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32;

import java.math.BigInteger;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.crypto.ec.CustomNamedCurves;
import org.spongycastle.math.ec.ECPoint;

final class Secp256k1SC {
    static final X9ECParameters CURVE = CustomNamedCurves.getByName((String)"secp256k1");

    Secp256k1SC() {
    }

    static BigInteger n() {
        return CURVE.getN();
    }

    static byte[] pointSerP(ECPoint point) {
        return point.getEncoded(true);
    }

    static byte[] pointSerP_gMultiply(BigInteger p) {
        return Secp256k1SC.pointSerP(Secp256k1SC.gMultiply(p));
    }

    static ECPoint gMultiplyAndAddPoint(BigInteger p, byte[] toAdd) {
        return Secp256k1SC.gMultiply(p).add(Secp256k1SC.decode(toAdd));
    }

    private static ECPoint decode(byte[] toAdd) {
        return CURVE.getCurve().decodePoint(toAdd);
    }

    private static ECPoint gMultiply(BigInteger p) {
        return CURVE.getG().multiply(p);
    }
}

