/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip32.networks;

import io.github.novacrypto.bip32.Network;
import io.github.novacrypto.bip32.Networks;
import io.github.novacrypto.bip32.networks.UnknownNetworkException;
import java.util.Arrays;
import java.util.List;

public final class NetworkCollection
implements Networks {
    private final List<? extends Network> networks;

    public NetworkCollection(Network ... networks) {
        this.networks = Arrays.asList(networks);
    }

    @Override
    public Network findByPrivateVersion(int privateVersion) {
        for (Network network : this.networks) {
            if (network.getPrivateVersion() != privateVersion) continue;
            return network;
        }
        throw new UnknownNetworkException(String.format("Can't find network that matches private version 0x%x", privateVersion));
    }

    @Override
    public Network findByPublicVersion(int publicVersion) {
        for (Network network : this.networks) {
            if (network.getPublicVersion() != publicVersion) continue;
            return network;
        }
        throw new UnknownNetworkException(String.format("Can't find network that matches public version 0x%x", publicVersion));
    }
}

