/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import io.github.novacrypto.bip39.ByteUtils;
import io.github.novacrypto.bip39.WordList;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class MnemonicGenerator {
    private final WordList wordList;

    public MnemonicGenerator(WordList wordList) {
        this.wordList = wordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMnemonic(CharSequence entropyHex, Target target) {
        int length = entropyHex.length();
        if (length % 2 == 1) {
            throw new RuntimeException("Length of hex chars must be divisible by 2");
        }
        byte[] entropy = new byte[length / 2];
        try {
            int i = 0;
            int j = 0;
            while (i < length) {
                entropy[j] = (byte)(MnemonicGenerator.parseHex(entropyHex.charAt(i)) << 4 | MnemonicGenerator.parseHex(entropyHex.charAt(i + 1)));
                i += 2;
                ++j;
            }
            this.createMnemonic(entropy, target);
        }
        finally {
            Arrays.fill(entropy, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMnemonic(byte[] entropy, Target target) {
        int[] wordIndexes = MnemonicGenerator.wordIndexes(entropy);
        try {
            this.createMnemonic(wordIndexes, target);
        }
        finally {
            Arrays.fill(wordIndexes, 0);
        }
    }

    private void createMnemonic(int[] wordIndexes, Target target) {
        String space = String.valueOf(this.wordList.getSpace());
        for (int i = 0; i < wordIndexes.length; ++i) {
            if (i > 0) {
                target.append(space);
            }
            target.append(this.wordList.getWord(wordIndexes[i]));
        }
    }

    private static int[] wordIndexes(byte[] entropy) {
        int ent = entropy.length * 8;
        MnemonicGenerator.entropyLengthPreChecks(ent);
        byte[] entropyWithChecksum = Arrays.copyOf(entropy, entropy.length + 1);
        entropyWithChecksum[entropy.length] = MnemonicGenerator.firstByteOfSha256(entropy);
        int cs = ent / 32;
        int ms = (ent + cs) / 11;
        int[] wordIndexes = new int[ms];
        int i = 0;
        for (int wi = 0; wi < ms; ++wi) {
            wordIndexes[wi] = ByteUtils.next11Bits(entropyWithChecksum, i);
            i += 11;
        }
        return wordIndexes;
    }

    static byte firstByteOfSha256(byte[] entropy) {
        byte[] hash = MnemonicGenerator.sha256().digest(entropy);
        byte firstByte = hash[0];
        Arrays.fill(hash, (byte)0);
        return firstByte;
    }

    private static MessageDigest sha256() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static void entropyLengthPreChecks(int ent) {
        if (ent < 128) {
            throw new RuntimeException("Entropy too low, 128-256 bits allowed");
        }
        if (ent > 256) {
            throw new RuntimeException("Entropy too high, 128-256 bits allowed");
        }
        if (ent % 32 > 0) {
            throw new RuntimeException("Number of entropy bits must be divisible by 32");
        }
    }

    private static int parseHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new RuntimeException("Invalid hex char " + c);
    }

    public static interface Target {
        public void append(CharSequence var1);
    }
}

