/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.Normalizer;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public final class SeedCalculator {
    private final byte[] fixedSalt = SeedCalculator.getUtf8Bytes("mnemonic");
    private SecretKeyFactory skf = SeedCalculator.getPbkdf2WithHmacSHA512();

    public byte[] calculateSeed(String mnemonic, String passphrase) {
        mnemonic = Normalizer.normalize(mnemonic, Normalizer.Form.NFKD);
        passphrase = Normalizer.normalize(passphrase, Normalizer.Form.NFKD);
        char[] chars = mnemonic.toCharArray();
        byte[] salt2 = SeedCalculator.getUtf8Bytes(passphrase);
        byte[] salt = SeedCalculator.combine(this.fixedSalt, salt2);
        SeedCalculator.clear(salt2);
        PBEKeySpec spec = new PBEKeySpec(chars, salt, 2048, 512);
        Arrays.fill(chars, '\u0000');
        SeedCalculator.clear(salt);
        try {
            byte[] byArray = this.skf.generateSecret(spec).getEncoded();
            return byArray;
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        finally {
            spec.clearPassword();
        }
    }

    private static byte[] combine(byte[] array1, byte[] array2) {
        byte[] bytes = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, bytes, 0, array1.length);
        System.arraycopy(array2, 0, bytes, array1.length, bytes.length - array1.length);
        return bytes;
    }

    private static void clear(byte[] salt) {
        Arrays.fill(salt, (byte)0);
    }

    private static SecretKeyFactory getPbkdf2WithHmacSHA512() {
        try {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getUtf8Bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

