/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

final class ByteUtils {
    ByteUtils() {
    }

    static int next11Bits(byte[] bytes, int offset) {
        int skip = offset / 8;
        int lowerBitsToRemove = 13 - offset % 8;
        return ((bytes[skip] & 0xFF) << 16 | (bytes[skip + 1] & 0xFF) << 8 | (lowerBitsToRemove < 8 ? bytes[skip + 2] & 0xFF : 0)) >> lowerBitsToRemove & 0x7FF;
    }

    static void writeNext11(byte[] bytes, int value, int offset) {
        int skip = offset / 8;
        int bitSkip = offset % 8;
        byte firstValue = bytes[skip];
        byte toWrite = (byte)(value >> 3 + bitSkip);
        bytes[skip] = (byte)(firstValue | toWrite);
        byte valueInByte = bytes[skip + 1];
        int i = 5 - bitSkip;
        byte toWrite2 = (byte)(i > 0 ? value << i : value >> -i);
        bytes[skip + 1] = (byte)(valueInByte | toWrite2);
        if (bitSkip >= 6) {
            valueInByte = bytes[skip + 2];
            toWrite = (byte)(value << 13 - bitSkip);
            bytes[skip + 2] = (byte)(valueInByte | toWrite);
        }
    }
}

