/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import io.github.novacrypto.bip39.ByteUtils;
import io.github.novacrypto.bip39.CharSequenceComparators;
import io.github.novacrypto.bip39.CharSequenceSplitter;
import io.github.novacrypto.bip39.MnemonicGenerator;
import io.github.novacrypto.bip39.Validation.InvalidChecksumException;
import io.github.novacrypto.bip39.Validation.InvalidWordCountException;
import io.github.novacrypto.bip39.Validation.WordNotFoundException;
import io.github.novacrypto.bip39.WordList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class MnemonicValidator {
    private final WordAndIndex[] words = new WordAndIndex[2048];
    final CharSequenceSplitter charSequenceSplitter;
    static final Comparator<WordAndIndex> wordListSortOrder = new Comparator<WordAndIndex>(){

        @Override
        public int compare(WordAndIndex o1, WordAndIndex o2) {
            return CharSequenceComparators.ALPHABETICAL.compare(o1.word, o2.word);
        }
    };

    private MnemonicValidator(WordList wordList) {
        for (int i = 0; i < 2048; ++i) {
            String word = wordList.getWord(i);
            this.words[i] = new WordAndIndex(i, word);
        }
        this.charSequenceSplitter = new CharSequenceSplitter(wordList.getSpace());
        Arrays.sort(this.words, wordListSortOrder);
    }

    public static MnemonicValidator ofWordList(WordList wordList) {
        return new MnemonicValidator(wordList);
    }

    public void validate(CharSequence mnemonic) throws InvalidChecksumException, InvalidWordCountException, WordNotFoundException {
        int cs;
        int ent;
        int[] wordIndexes = this.findWordIndexes(mnemonic);
        int ms = wordIndexes.length;
        int entPlusCs = ms * 11;
        if (entPlusCs != (ent = entPlusCs * 32 / 33) + (cs = ent / 32)) {
            throw new InvalidWordCountException();
        }
        byte[] entropyWithChecksum = new byte[(entPlusCs + 7) / 8];
        this.wordIndexesToEntropyWithCheckSum(wordIndexes, entropyWithChecksum);
        Arrays.fill(wordIndexes, 0);
        byte[] entropy = Arrays.copyOf(entropyWithChecksum, entropyWithChecksum.length - 1);
        byte lastByte = entropyWithChecksum[entropyWithChecksum.length - 1];
        Arrays.fill(entropyWithChecksum, (byte)0);
        byte sha = MnemonicGenerator.firstByteOfSha256(entropy);
        byte mask = this.maskOfFirstNBits(cs);
        if (((sha ^ lastByte) & mask) != 0) {
            throw new InvalidChecksumException();
        }
    }

    private int[] findWordIndexes(CharSequence mnemonic) throws WordNotFoundException {
        List<CharSequence> split = this.charSequenceSplitter.split(mnemonic);
        int ms = split.size();
        int[] result = new int[ms];
        for (int i = 0; i < ms; ++i) {
            result[i] = this.findWordIndex(split.get(i));
        }
        return result;
    }

    private int findWordIndex(CharSequence buffer) throws WordNotFoundException {
        WordAndIndex key = new WordAndIndex(-1, buffer);
        int index = Arrays.binarySearch(this.words, key, wordListSortOrder);
        if (index < 0) {
            int suggestion;
            int insertionPoint = -index - 1;
            int n = suggestion = insertionPoint == 0 ? insertionPoint : insertionPoint - 1;
            if (suggestion + 1 == this.words.length) {
                --suggestion;
            }
            throw new WordNotFoundException(buffer, this.words[suggestion].word, this.words[suggestion + 1].word);
        }
        return this.words[index].index;
    }

    private void wordIndexesToEntropyWithCheckSum(int[] wordIndexes, byte[] entropyWithChecksum) {
        int i = 0;
        int bi = 0;
        while (i < wordIndexes.length) {
            ByteUtils.writeNext11(entropyWithChecksum, wordIndexes[i], bi);
            ++i;
            bi += 11;
        }
    }

    private byte maskOfFirstNBits(int n) {
        return (byte)(~((1 << 8 - n) - 1));
    }

    private class WordAndIndex {
        final CharSequence word;
        final int index;

        WordAndIndex(int i, CharSequence word) {
            this.word = word;
            this.index = i;
        }
    }
}

