/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import io.github.novacrypto.bip39.ByteUtils;
import io.github.novacrypto.bip39.CharSequenceComparators;
import io.github.novacrypto.bip39.CharSequenceSplitter;
import io.github.novacrypto.bip39.MnemonicGenerator;
import io.github.novacrypto.bip39.Normalization;
import io.github.novacrypto.bip39.Validation.InvalidChecksumException;
import io.github.novacrypto.bip39.Validation.InvalidWordCountException;
import io.github.novacrypto.bip39.Validation.UnexpectedWhiteSpaceException;
import io.github.novacrypto.bip39.Validation.WordNotFoundException;
import io.github.novacrypto.bip39.WordList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public final class MnemonicValidator {
    private final WordAndIndex[] words = new WordAndIndex[2048];
    private final CharSequenceSplitter charSequenceSplitter;
    private static final Comparator<WordAndIndex> wordListSortOrder = new Comparator<WordAndIndex>(){

        @Override
        public int compare(WordAndIndex o1, WordAndIndex o2) {
            return CharSequenceComparators.ALPHABETICAL.compare(o1.normalized, o2.normalized);
        }
    };

    private MnemonicValidator(WordList wordList) {
        for (int i = 0; i < 2048; ++i) {
            this.words[i] = new WordAndIndex(i, wordList.getWord(i));
        }
        this.charSequenceSplitter = new CharSequenceSplitter(wordList.getSpace(), Normalization.normalizeNFKD(wordList.getSpace()));
        Arrays.sort(this.words, wordListSortOrder);
    }

    public static MnemonicValidator ofWordList(WordList wordList) {
        return new MnemonicValidator(wordList);
    }

    public void validate(String mnemonic) throws InvalidChecksumException, InvalidWordCountException, WordNotFoundException, UnexpectedWhiteSpaceException {
        this.validate(this.charSequenceSplitter.split(mnemonic));
    }

    public void validate(Collection<? extends CharSequence> mnemonic) throws InvalidChecksumException, InvalidWordCountException, WordNotFoundException, UnexpectedWhiteSpaceException {
        int[] wordIndexes = this.findWordIndexes(mnemonic);
        try {
            MnemonicValidator.validate(wordIndexes);
        }
        finally {
            Arrays.fill(wordIndexes, 0);
        }
    }

    private static void validate(int[] wordIndexes) throws InvalidWordCountException, InvalidChecksumException {
        int ms = wordIndexes.length;
        int entPlusCs = ms * 11;
        int ent = entPlusCs * 32 / 33;
        int cs = ent / 32;
        if (entPlusCs != ent + cs) {
            throw new InvalidWordCountException();
        }
        byte[] entropyWithChecksum = new byte[(entPlusCs + 7) / 8];
        MnemonicValidator.wordIndexesToEntropyWithCheckSum(wordIndexes, entropyWithChecksum);
        Arrays.fill(wordIndexes, 0);
        byte[] entropy = Arrays.copyOf(entropyWithChecksum, entropyWithChecksum.length - 1);
        byte lastByte = entropyWithChecksum[entropyWithChecksum.length - 1];
        Arrays.fill(entropyWithChecksum, (byte)0);
        byte sha = MnemonicGenerator.firstByteOfSha256(entropy);
        byte mask = MnemonicValidator.maskOfFirstNBits(cs);
        if (((sha ^ lastByte) & mask) != 0) {
            throw new InvalidChecksumException();
        }
    }

    private int[] findWordIndexes(Collection<? extends CharSequence> split) throws UnexpectedWhiteSpaceException, WordNotFoundException {
        int ms = split.size();
        int[] result = new int[ms];
        int i = 0;
        for (CharSequence charSequence : split) {
            if (charSequence.length() == 0) {
                throw new UnexpectedWhiteSpaceException();
            }
            result[i++] = this.findWordIndex(charSequence);
        }
        return result;
    }

    private int findWordIndex(CharSequence buffer) throws WordNotFoundException {
        WordAndIndex key = new WordAndIndex(-1, buffer.toString());
        int index = Arrays.binarySearch(this.words, key, wordListSortOrder);
        if (index < 0) {
            int suggestion;
            int insertionPoint = -index - 1;
            int n = suggestion = insertionPoint == 0 ? insertionPoint : insertionPoint - 1;
            if (suggestion + 1 == this.words.length) {
                --suggestion;
            }
            throw new WordNotFoundException(buffer, this.words[suggestion].word, this.words[suggestion + 1].word);
        }
        return this.words[index].index;
    }

    private static void wordIndexesToEntropyWithCheckSum(int[] wordIndexes, byte[] entropyWithChecksum) {
        int i = 0;
        int bi = 0;
        while (i < wordIndexes.length) {
            ByteUtils.writeNext11(entropyWithChecksum, wordIndexes[i], bi);
            ++i;
            bi += 11;
        }
    }

    private static byte maskOfFirstNBits(int n) {
        return (byte)(~((1 << 8 - n) - 1));
    }

    private class WordAndIndex {
        final String word;
        final String normalized;
        final int index;

        WordAndIndex(int i, String word) {
            this.word = word;
            this.normalized = Normalization.normalizeNFKD(word);
            this.index = i;
        }
    }
}

