/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import io.github.novacrypto.bip39.SeedCalculator;
import io.github.novacrypto.bip39.WordList;
import io.github.novacrypto.bip39.WordNotExactlyAsInSuppliedWordList;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class SeedCalculatorByWordListLookUp {
    private final SeedCalculator seedCalculator;
    private final Map<CharSequence, char[]> map = new HashMap<CharSequence, char[]>();

    SeedCalculatorByWordListLookUp(SeedCalculator seedCalculator, WordList wordList) {
        this.seedCalculator = seedCalculator;
        for (int i = 0; i < 2048; ++i) {
            String word = wordList.getWord(i);
            this.map.put(word, Normalizer.normalize(word, Normalizer.Form.NFKD).toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public byte[] calculateSeed(Collection<? extends CharSequence> mnemonicFromWordList, String passphrase) {
        int words = mnemonicFromWordList.size();
        char[][] chars = new char[words][];
        int count = 0;
        int wordIndex = 0;
        for (CharSequence charSequence : mnemonicFromWordList) {
            char[] wordChars = this.map.get(charSequence);
            if (wordChars == null) {
                throw new WordNotExactlyAsInSuppliedWordList();
            }
            chars[wordIndex++] = wordChars;
            count += wordChars.length;
        }
        char[] mnemonicChars = new char[count += words - 1];
        try {
            boolean bl = false;
            for (int i = 0; i < chars.length; ++i) {
                void var8_10;
                System.arraycopy(chars[i], 0, mnemonicChars, (int)var8_10, chars[i].length);
                var8_10 += chars[i].length;
                if (i >= chars.length - 1) continue;
                mnemonicChars[var8_10++] = 32;
            }
            byte[] byArray = this.seedCalculator.calculateSeed(mnemonicChars, passphrase);
            return byArray;
        }
        finally {
            Arrays.fill(mnemonicChars, '\u0000');
            Arrays.fill((Object[])chars, null);
        }
    }
}

