/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.hashing;

import io.github.novacrypto.hashing.Sha256;
import org.spongycastle.crypto.digests.RIPEMD160Digest;

public final class Hash160 {
    private static final int RIPEMD160_DIGEST_SIZE = 20;

    public static byte[] hash160(byte[] bytes) {
        return Hash160.ripemd160(Sha256.sha256((byte[])bytes));
    }

    public static void hash160into(byte[] target, int offset, byte[] bytes) {
        Hash160.ripemd160into(Sha256.sha256((byte[])bytes), target, offset);
    }

    private static byte[] ripemd160(byte[] bytes) {
        byte[] output = new byte[20];
        Hash160.ripemd160into(bytes, output, 0);
        return output;
    }

    private static void ripemd160into(byte[] bytes, byte[] target, int offset) {
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(target, offset);
    }
}

