/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

final class SecureByteBuffer
implements Closeable {
    private final ByteBuffer data;
    private final ByteBuffer key;

    static SecureByteBuffer withCapacity(int capacity) {
        return new SecureByteBuffer(capacity);
    }

    private SecureByteBuffer(int capacity) {
        this.data = SecureByteBuffer.allocatePinnedBuffer(capacity);
        this.key = SecureByteBuffer.allocatePinnedBuffer(capacity);
        SecureByteBuffer.populateBufferWithSecureKeyData(this.key);
    }

    private static ByteBuffer allocatePinnedBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    private static void populateBufferWithSecureKeyData(ByteBuffer key) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[key.capacity()];
        ((Random)random).nextBytes(bytes);
        key.put(bytes);
        Arrays.fill(bytes, (byte)0);
    }

    SecureByteBuffer() {
        this(1024);
    }

    void append(byte b) {
        this.data.put((byte)(b ^ this.key.get(this.data.position())));
    }

    int length() {
        return this.data.position();
    }

    byte get(int i) {
        return (byte)(this.data.get(i) ^ this.key.get(i));
    }

    int capacity() {
        return this.data.capacity();
    }

    @Override
    public void close() {
        this.data.position(0);
        this.key.position(0);
        this.data.put(this.key);
    }
}

