/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto;

import io.github.novacrypto.SecureByteBuffer;
import java.io.Closeable;

final class SecureCharBuffer
implements Closeable {
    private final SecureByteBuffer buffer;

    static SecureCharBuffer withCapacity(int capacity) {
        return new SecureCharBuffer(capacity);
    }

    private SecureCharBuffer(int capacity) {
        this.buffer = SecureByteBuffer.withCapacity(capacity * 2);
    }

    SecureCharBuffer() {
        this(512);
    }

    void append(char c) {
        byte msb = (byte)(c >> 8);
        byte lsb = (byte)(c & 0xFF);
        this.buffer.append(msb);
        this.buffer.append(lsb);
    }

    int length() {
        return this.buffer.length() / 2;
    }

    char get(int i) {
        int position = i * 2;
        byte msb = this.buffer.get(position);
        byte lsb = this.buffer.get(position + 1);
        return (char)(msb << 8 | lsb);
    }

    int capacity() {
        return this.buffer.capacity() / 2;
    }

    @Override
    public void close() {
        this.buffer.close();
    }
}

