/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto;

final class ProxyCharSequence
implements CharSequence {
    private final CharSequence parent;
    private final int start;
    private final int end;

    static CharSequence secureSubSequenceProxy(CharSequence parent, int start, int end) {
        int length = parent.length();
        if (start > end || start < 0 || end > length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (start == 0 && end == length) {
            return parent;
        }
        return new ProxyCharSequence(parent, start, end);
    }

    private ProxyCharSequence(CharSequence parent, int start, int end) {
        this.parent = parent;
        this.start = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        return this.parent.charAt(index + this.start);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.parent.subSequence(this.start + start, this.start + end);
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException();
    }
}

