/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto;

import io.github.novacrypto.ToStringStrategy;

final class ProxyCharSequence
implements CharSequence {
    private final CharSequence parent;
    private final int start;
    private final int end;
    private final ToStringStrategy toStringStrategy;

    static CharSequence secureSubSequenceProxy(CharSequence parent, int start, int end, ToStringStrategy toStringStrategy) {
        int length = parent.length();
        if (start > end || start < 0 || end > length) {
            throw new StringIndexOutOfBoundsException();
        }
        return new ProxyCharSequence(parent, start, end, toStringStrategy);
    }

    private ProxyCharSequence(CharSequence parent, int start, int end, ToStringStrategy toStringStrategy) {
        this.parent = parent;
        this.start = start;
        this.end = end;
        this.toStringStrategy = toStringStrategy;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.parent.charAt(index + this.start);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return ProxyCharSequence.secureSubSequenceProxy(this.parent, this.start + start, this.start + end, this.toStringStrategy);
    }

    @Override
    public String toString() {
        return this.toStringStrategy.toString(this);
    }
}

