/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto;

import io.github.novacrypto.ProxyCharSequence;
import io.github.novacrypto.SecureByteBuffer;
import io.github.novacrypto.ToStringStrategy;
import java.io.Closeable;

public final class SecureCharBuffer
implements Closeable,
CharSequence {
    private final SecureByteBuffer buffer;

    public static SecureCharBuffer withCapacity(int capacity) {
        return new SecureCharBuffer(capacity);
    }

    private SecureCharBuffer(int capacity) {
        this.buffer = SecureByteBuffer.withCapacity(capacity * 2);
    }

    public SecureCharBuffer() {
        this(512);
    }

    public void append(char c) {
        byte msb = (byte)(c >> 8);
        byte lsb = (byte)(c & 0xFF);
        this.buffer.append(msb);
        this.buffer.append(lsb);
    }

    public void append(CharSequence data) {
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            this.append(data.charAt(i));
        }
    }

    @Override
    public int length() {
        return this.buffer.length() / 2;
    }

    @Override
    public char charAt(int index) {
        int position = index * 2;
        byte msb = this.buffer.get(position);
        byte lsb = this.buffer.get(position + 1);
        return (char)(msb << 8 | lsb);
    }

    public char get(int index) {
        return this.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return ProxyCharSequence.secureSubSequenceProxy(this, start, end, ToStringStrategy.RESTRICT);
    }

    public CharSequence toStringAble() {
        return ProxyCharSequence.secureSubSequenceProxy(this, 0, this.length(), ToStringStrategy.ALLOW);
    }

    public int capacity() {
        return this.buffer.capacity() / 2;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException();
    }
}

