/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.metrics;

import io.github.detekt.metrics.ComplexityMetric;
import io.gitlab.arturbosch.detekt.api.Detektion;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/detekt/metrics/ComplexityReportGenerator;", "", "complexityMetric", "Lio/github/detekt/metrics/ComplexityMetric;", "(Lio/github/detekt/metrics/ComplexityMetric;)V", "commentSourceRatio", "", "mccPerThousandLines", "numberOfSmells", "smellPerThousandLines", "cannotGenerate", "", "generate", "", "", "Factory", "detekt-metrics"})
public final class ComplexityReportGenerator {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final ComplexityMetric complexityMetric;
    private int numberOfSmells;
    private int smellPerThousandLines;
    private int mccPerThousandLines;
    private int commentSourceRatio;

    public ComplexityReportGenerator(@NotNull ComplexityMetric complexityMetric) {
        Intrinsics.checkNotNullParameter((Object)complexityMetric, (String)"complexityMetric");
        this.complexityMetric = complexityMetric;
    }

    @Nullable
    public final List<String> generate() {
        if (this.cannotGenerate()) {
            return null;
        }
        Object[] objectArray = new String[10];
        String string = "%,d lines of code (loc)";
        Locale locale = Locale.US;
        Object[] objectArray2 = new Object[]{this.complexityMetric.getLoc()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        string = "%,d source lines of code (sloc)";
        locale = Locale.US;
        objectArray2 = new Object[]{this.complexityMetric.getSloc()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        string = "%,d logical lines of code (lloc)";
        locale = Locale.US;
        objectArray2 = new Object[]{this.complexityMetric.getLloc()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        string = "%,d comment lines of code (cloc)";
        locale = Locale.US;
        objectArray2 = new Object[]{this.complexityMetric.getCloc()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        string = "%,d cyclomatic complexity (mcc)";
        locale = Locale.US;
        objectArray2 = new Object[]{this.complexityMetric.getMcc()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        string = "%,d cognitive complexity";
        locale = Locale.US;
        objectArray2 = new Object[]{this.complexityMetric.getCognitiveComplexity()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        string = "%,d number of total code smells";
        locale = Locale.US;
        objectArray2 = new Object[]{this.numberOfSmells};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        string = "%,d%% comment source ratio";
        locale = Locale.US;
        objectArray2 = new Object[]{this.commentSourceRatio};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        string = "%,d mcc per 1,000 lloc";
        locale = Locale.US;
        objectArray2 = new Object[]{this.mccPerThousandLines};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        string = "%,d code smells per 1,000 lloc";
        locale = Locale.US;
        objectArray2 = new Object[]{this.smellPerThousandLines};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(locale, this, *args)");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean cannotGenerate() {
        int n;
        Object object = new Integer[]{this.complexityMetric.getMcc(), this.complexityMetric.getCloc(), this.complexityMetric.getCognitiveComplexity()};
        if (SetsKt.setOf((Object[])object).contains(null)) {
            return true;
        }
        if (this.complexityMetric.getLloc() == null) return true;
        Integer n2 = this.complexityMetric.getLloc();
        if (n2 != null && n2 == 0) {
            return true;
        }
        if (this.complexityMetric.getSloc() == null) return true;
        Integer n3 = this.complexityMetric.getSloc();
        if (n3 != null && n3 == 0) {
            return true;
        }
        object = this.complexityMetric.getFindings();
        ComplexityReportGenerator complexityReportGenerator = this;
        int n4 = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            Map.Entry entry = (Map.Entry)t;
            n = n4;
            boolean bl = false;
            int n5 = ((List)it.getValue()).size();
            n4 = n + n5;
        }
        complexityReportGenerator.numberOfSmells = n = n4;
        this.smellPerThousandLines = this.numberOfSmells * 1000 / this.complexityMetric.getLloc();
        Integer n6 = this.complexityMetric.getMcc();
        if (n6 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.mccPerThousandLines = ((Number)n6).intValue() * 1000 / this.complexityMetric.getLloc();
        Integer n7 = this.complexityMetric.getCloc();
        if (n7 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.commentSourceRatio = ((Number)n7).intValue() * 100 / this.complexityMetric.getSloc();
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/detekt/metrics/ComplexityReportGenerator$Factory;", "", "()V", "create", "Lio/github/detekt/metrics/ComplexityReportGenerator;", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "detekt-metrics"})
    public static final class Factory {
        private Factory() {
        }

        @NotNull
        public final ComplexityReportGenerator create(@NotNull Detektion detektion) {
            Intrinsics.checkNotNullParameter((Object)detektion, (String)"detektion");
            return new ComplexityReportGenerator(new ComplexityMetric(detektion));
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

