/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/RethrowCaughtException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "violatingThrowExpressionFrom", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "visitTryExpression", "", "tryExpr", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "detekt-rules-exceptions"})
public final class RethrowCaughtException
extends Rule {
    @NotNull
    private final Issue issue;

    public RethrowCaughtException(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("RethrowCaughtException", Severity.CodeSmell, "Do not rethrow a caught exception of the same type.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ RethrowCaughtException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitTryExpression(@NotNull KtTryExpression tryExpr) {
        List list;
        block9: {
            void $this$mapTo$iv$iv;
            KtCatchClause[] catchClauses;
            Intrinsics.checkNotNullParameter((Object)tryExpr, (String)"tryExpr");
            PsiElement $this$getChildrenOfType$iv = (PsiElement)tryExpr;
            boolean $i$f$getChildrenOfType = false;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtCatchClause.class);
            if (psiElementArray == null) {
                psiElementArray = (PsiElement[])new KtCatchClause[0];
            }
            KtCatchClause[] $this$map$iv = catchClauses = (KtCatchClause[])psiElementArray;
            boolean $i$f$map = false;
            KtCatchClause[] ktCatchClauseArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.violatingThrowExpressionFrom((KtCatchClause)it));
            }
            List $this$takeLastWhile$iv = (List)destination$iv$iv;
            boolean $i$f$takeLastWhile = false;
            if ($this$takeLastWhile$iv.isEmpty()) {
                list = CollectionsKt.emptyList();
            } else {
                ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    KtThrowExpression it = (KtThrowExpression)iterator$iv.previous();
                    boolean bl = false;
                    if (it != null) continue;
                    iterator$iv.next();
                    int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                    if (expectedSize$iv == 0) {
                        list = CollectionsKt.emptyList();
                    } else {
                        ArrayList arrayList;
                        ArrayList $this$takeLastWhile_u24lambda_u245$iv = arrayList = new ArrayList(expectedSize$iv);
                        boolean bl2 = false;
                        while (iterator$iv.hasNext()) {
                            $this$takeLastWhile_u24lambda_u245$iv.add(iterator$iv.next());
                        }
                        list = arrayList;
                    }
                    break block9;
                }
                list = CollectionsKt.toList((Iterable)$this$takeLastWhile$iv);
            }
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtThrowExpression it;
            KtThrowExpression violation = (KtThrowExpression)element$iv;
            boolean bl = false;
            if (violation == null) continue;
            boolean bl3 = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitTryExpression(tryExpr);
    }

    private final KtThrowExpression violatingThrowExpressionFrom(KtCatchClause catchClause) {
        KtParameter ktParameter = catchClause.getCatchParameter();
        String exceptionName = ktParameter != null ? ktParameter.getName() : null;
        Object[] objectArray = catchClause.getCatchBody();
        PsiElement psiElement = objectArray != null && (objectArray = objectArray.getChildren()) != null ? (PsiElement)ArraysKt.firstOrNull((Object[])objectArray) : null;
        KtThrowExpression throwExpression2 = psiElement instanceof KtThrowExpression ? (KtThrowExpression)psiElement : null;
        KtThrowExpression ktThrowExpression = throwExpression2;
        if (Intrinsics.areEqual((Object)(ktThrowExpression != null && (ktThrowExpression = ktThrowExpression.getThrownExpression()) != null ? ktThrowExpression.getText() : null), (Object)exceptionName)) {
            return throwExpression2;
        }
        return null;
    }

    public RethrowCaughtException() {
        this(null, 1, null);
    }
}

