/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u0006*\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/ReturnFromFinally;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoreLabeled", "", "getIgnoreLabeled$annotations", "()V", "getIgnoreLabeled", "()Z", "ignoreLabeled$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "canFilterLabeledExpression", "returnStmt", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "isReturnFromTargetFunction", "blockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "returnStmts", "visitTryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "typeEqualsTo", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "detekt-rules-exceptions"})
public final class ReturnFromFinally
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoreLabeled$delegate;

    public ReturnFromFinally(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ReturnFromFinally", Severity.Defect, "Do not return within a finally statement. This can discard exceptions.", Debt.Companion.getTWENTY_MINS());
        this.ignoreLabeled$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ ReturnFromFinally(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIgnoreLabeled() {
        return (Boolean)this.ignoreLabeled$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="ignores labeled return statements")
    private static /* synthetic */ void getIgnoreLabeled$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public void visitTryExpression(@NotNull KtTryExpression expression) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitTryExpression(expression);
        KtFinallySection ktFinallySection = expression.getFinallyBlock();
        if (ktFinallySection == null) {
            return;
        }
        KtFinallySection finallyBlock = ktFinallySection;
        if (BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)expression), (BindingContext)this.getBindingContext()) && this.typeEqualsTo(finallyBlock, CallUtilKt.getType((KtExpression)((KtExpression)expression), (BindingContext)this.getBindingContext()))) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)finallyBlock), (int)0, (int)2, null), "Contents of the finally block do not affect the result of the expression.", null, null, 24, null));
        }
        KtBlockExpression ktBlockExpression = finallyBlock.getFinalExpression();
        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"finallyBlock.finalExpression");
        PsiElement psiElement = (PsiElement)ktBlockExpression;
        Function1 predicate$iv = (Function1)new Function1<KtReturnExpression, Boolean>(this, finallyBlock){
            final /* synthetic */ ReturnFromFinally this$0;
            final /* synthetic */ KtFinallySection $finallyBlock;
            {
                this.this$0 = $receiver;
                this.$finallyBlock = $finallyBlock;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtReturnExpression returnExpression) {
                Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
                KtBlockExpression ktBlockExpression = this.$finallyBlock.getFinalExpression();
                Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"finallyBlock.finalExpression");
                return ReturnFromFinally.access$isReturnFromTargetFunction(this.this$0, ktBlockExpression, returnExpression) && ReturnFromFinally.access$canFilterLabeledExpression(this.this$0, returnExpression);
            }
        };
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var8_11 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var11_15 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        Iterable $this$forEach$iv = (List)to$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtReturnExpression it = (KtReturnExpression)element$iv;
            boolean bl = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean isReturnFromTargetFunction(KtBlockExpression blockExpression, KtReturnExpression returnStmts) {
        KtCallableDeclaration ktCallableDeclaration = BindingContextUtilsKt.getTargetFunction((KtReturnExpression)returnStmts, (BindingContext)this.getBindingContext());
        if (ktCallableDeclaration == null) {
            return false;
        }
        KtCallableDeclaration targetFunction = ktCallableDeclaration;
        Iterable targetFunctionBodyExpressionStatements = SequencesKt.asIterable((Sequence)KtPsiUtilKt.blockExpressionsOrSingle((KtElement)((KtElement)targetFunction)));
        return PsiUtilsKt.isInsideOf((PsiElement)((PsiElement)blockExpression), (Iterable)targetFunctionBodyExpressionStatements);
    }

    private final boolean canFilterLabeledExpression(KtReturnExpression returnStmt) {
        return !this.getIgnoreLabeled() || returnStmt.getLabeledExpression() == null;
    }

    private final boolean typeEqualsTo(KtFinallySection $this$typeEqualsTo, KotlinType type) {
        KtBlockExpression finallyExpression = $this$typeEqualsTo.getFinalExpression();
        if (finallyExpression.getStatements().isEmpty()) {
            return false;
        }
        KtBlockExpression ktBlockExpression = $this$typeEqualsTo.getFinalExpression();
        Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"finalExpression");
        return Intrinsics.areEqual((Object)CallUtilKt.getType((KtExpression)((KtExpression)ktBlockExpression), (BindingContext)this.getBindingContext()), (Object)type);
    }

    public ReturnFromFinally() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$isReturnFromTargetFunction(ReturnFromFinally $this, KtBlockExpression blockExpression, KtReturnExpression returnStmts) {
        return $this.isReturnFromTargetFunction(blockExpression, returnStmts);
    }

    public static final /* synthetic */ boolean access$canFilterLabeledExpression(ReturnFromFinally $this, KtReturnExpression returnStmt) {
        return $this.canFilterLabeledExpression(returnStmt);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ReturnFromFinally.class, "ignoreLabeled", "getIgnoreLabeled()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

