/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.b.b;
import io.reactivex.internal.c.j;
import io.reactivex.internal.d.a.h;
import io.reactivex.internal.d.c.f;
import io.reactivex.internal.d.f.a;
import io.reactivex.internal.d.f.d;
import io.reactivex.internal.d.f.e;
import io.reactivex.internal.d.f.g;
import io.reactivex.internal.d.f.i;
import io.reactivex.internal.d.f.k;
import io.reactivex.internal.d.f.l;
import io.reactivex.internal.d.f.m;
import io.reactivex.internal.d.f.n;
import io.reactivex.internal.d.f.o;
import io.reactivex.internal.d.f.p;
import io.reactivex.internal.d.f.q;
import io.reactivex.internal.d.f.r;
import io.reactivex.internal.d.f.s;
import io.reactivex.internal.d.f.u;
import io.reactivex.internal.functions.Functions;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public abstract class Single<T>
implements SingleSource<T> {
    @CheckReturnValue
    @NonNull
    public static <T> Single<T> create(SingleOnSubscribe<T> singleOnSubscribe) {
        io.reactivex.internal.functions.a.a(singleOnSubscribe, "source is null");
        return RxJavaPlugins.onAssembly(new a<T>(singleOnSubscribe));
    }

    @CheckReturnValue
    @NonNull
    public static <T> Single<T> defer(Callable<? extends SingleSource<? extends T>> callable) {
        io.reactivex.internal.functions.a.a(callable, "singleSupplier is null");
        return RxJavaPlugins.onAssembly(new io.reactivex.internal.d.f.b(callable));
    }

    @CheckReturnValue
    @NonNull
    public static <T> Single<T> error(Throwable object) {
        io.reactivex.internal.functions.a.a(object, "exception is null");
        object = Functions.justCallable(object);
        io.reactivex.internal.functions.a.a(object, "errorSupplier is null");
        return RxJavaPlugins.onAssembly(new g((Callable<? extends Throwable>)object));
    }

    @CheckReturnValue
    @NonNull
    public static <T> Single<T> fromCallable(Callable<? extends T> callable) {
        io.reactivex.internal.functions.a.a(callable, "callable is null");
        return RxJavaPlugins.onAssembly(new k<T>(callable));
    }

    @CheckReturnValue
    @NonNull
    public static <T> Single<T> just(T t2) {
        io.reactivex.internal.functions.a.a(t2, "item is null");
        return RxJavaPlugins.onAssembly(new l<T>(t2));
    }

    @CheckReturnValue
    @NonNull
    public static <T, R> Single<R> zip(Iterable<? extends SingleSource<? extends T>> iterable, Function<? super Object[], ? extends R> function) {
        io.reactivex.internal.functions.a.a(function, "zipper is null");
        io.reactivex.internal.functions.a.a(iterable, "sources is null");
        return RxJavaPlugins.onAssembly(new u(iterable, function));
    }

    @CheckReturnValue
    public final Single<T> delaySubscription(long l2, TimeUnit object) {
        TimeUnit timeUnit = object;
        object = Schedulers.computation();
        Object object2 = timeUnit;
        long l3 = l2;
        Single single = this;
        object2 = Observable.timer(l3, object2, (Scheduler)object);
        io.reactivex.internal.functions.a.a(object2, "other is null");
        return RxJavaPlugins.onAssembly(new d(single, object2));
    }

    @CheckReturnValue
    @NonNull
    public final Single<T> doOnSuccess(Consumer<? super T> consumer) {
        io.reactivex.internal.functions.a.a(consumer, "onSuccess is null");
        return RxJavaPlugins.onAssembly(new io.reactivex.internal.d.f.f<T>(this, consumer));
    }

    @CheckReturnValue
    @NonNull
    public final Single<T> doOnError(Consumer<? super Throwable> consumer) {
        io.reactivex.internal.functions.a.a(consumer, "onError is null");
        return RxJavaPlugins.onAssembly(new e(this, consumer));
    }

    @CheckReturnValue
    @NonNull
    public final Maybe<T> filter(Predicate<? super T> predicate) {
        io.reactivex.internal.functions.a.a(predicate, "predicate is null");
        return RxJavaPlugins.a(new f<T>(this, predicate));
    }

    @CheckReturnValue
    @NonNull
    public final <R> Single<R> flatMap(Function<? super T, ? extends SingleSource<? extends R>> function) {
        io.reactivex.internal.functions.a.a(function, "mapper is null");
        return RxJavaPlugins.onAssembly(new io.reactivex.internal.d.f.h(this, function));
    }

    @CheckReturnValue
    @NonNull
    public final <R> Maybe<R> flatMapMaybe(Function<? super T, ? extends MaybeSource<? extends R>> function) {
        io.reactivex.internal.functions.a.a(function, "mapper is null");
        return RxJavaPlugins.a(new io.reactivex.internal.d.f.j(this, function));
    }

    @CheckReturnValue
    @NonNull
    public final <R> Observable<R> flatMapObservable(Function<? super T, ? extends ObservableSource<? extends R>> function) {
        io.reactivex.internal.functions.a.a(function, "mapper is null");
        return RxJavaPlugins.onAssembly(new io.reactivex.internal.d.d.h(this, function));
    }

    @CheckReturnValue
    @NonNull
    public final Completable flatMapCompletable(Function<? super T, ? extends CompletableSource> function) {
        io.reactivex.internal.functions.a.a(function, "mapper is null");
        return RxJavaPlugins.onAssembly(new i<T>(this, function));
    }

    @CheckReturnValue
    @NonNull
    public final <R> Single<R> map(Function<? super T, ? extends R> function) {
        io.reactivex.internal.functions.a.a(function, "mapper is null");
        return RxJavaPlugins.onAssembly(new m<T, R>(this, function));
    }

    @CheckReturnValue
    @NonNull
    public final Single<T> observeOn(Scheduler scheduler) {
        io.reactivex.internal.functions.a.a(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new n(this, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public final Single<T> onErrorReturn(Function<Throwable, ? extends T> function) {
        io.reactivex.internal.functions.a.a(function, "resumeFunction is null");
        return RxJavaPlugins.onAssembly(new o<Object>(this, function, null));
    }

    @CheckReturnValue
    @NonNull
    public final Single<T> onErrorResumeNext(Function<? super Throwable, ? extends SingleSource<? extends T>> function) {
        io.reactivex.internal.functions.a.a(function, "resumeFunctionInCaseOfError is null");
        return RxJavaPlugins.onAssembly(new p(this, function));
    }

    @CheckReturnValue
    @NonNull
    public final Disposable subscribe(Consumer<? super T> object, Consumer<? super Throwable> consumer) {
        io.reactivex.internal.functions.a.a(object, "onSuccess is null");
        io.reactivex.internal.functions.a.a(consumer, "onError is null");
        object = new j<T>(object, (Consumer<Throwable>)consumer);
        this.subscribe((SingleObserver<? super T>)object);
        return object;
    }

    @Override
    public final void subscribe(SingleObserver<? super T> object) {
        io.reactivex.internal.functions.a.a(object, "observer is null");
        object = RxJavaPlugins.a(this, object);
        io.reactivex.internal.functions.a.a(object, "The RxJavaPlugins.onSubscribe hook returned a null SingleObserver. Please check the handler provided to RxJavaPlugins.setOnSingleSubscribe for invalid null returns. Further reading: https://github.com/ReactiveX/RxJava/wiki/Plugins");
        try {
            this.subscribeActual((SingleObserver<? super T>)object);
            return;
        }
        catch (NullPointerException nullPointerException) {
            object = nullPointerException;
            throw nullPointerException;
        }
        catch (Throwable throwable) {
            object = throwable;
            Exceptions.throwIfFatal(throwable);
            NullPointerException nullPointerException = new NullPointerException("subscribeActual failed");
            nullPointerException.initCause((Throwable)object);
            throw nullPointerException;
        }
    }

    protected abstract void subscribeActual(@NonNull SingleObserver<? super T> var1);

    @CheckReturnValue
    @NonNull
    public final Single<T> subscribeOn(Scheduler scheduler) {
        io.reactivex.internal.functions.a.a(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new q(this, scheduler));
    }

    @CheckReturnValue
    public final Single<T> timeout(long l2, TimeUnit object, Scheduler scheduler) {
        TimeUnit timeUnit = object;
        Single single = null;
        object = scheduler;
        TimeUnit timeUnit2 = timeUnit;
        long l3 = l2;
        single = this;
        io.reactivex.internal.functions.a.a(timeUnit2, "unit is null");
        io.reactivex.internal.functions.a.a(object, "scheduler is null");
        return RxJavaPlugins.onAssembly(new r(single, l3, timeUnit2, (Scheduler)object, null));
    }

    @CheckReturnValue
    public final Completable ignoreElement() {
        return RxJavaPlugins.onAssembly(new h(this));
    }

    @CheckReturnValue
    public final Observable<T> toObservable() {
        if (this instanceof b) {
            return ((b)((Object)this)).a();
        }
        return RxJavaPlugins.onAssembly(new s(this));
    }
}

