/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.features.auth.providers;

import io.ktor.client.features.auth.AuthProvider;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.util.Base64Kt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.io.charsets.CharsetJVMKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lio/ktor/client/features/auth/providers/BasicAuthProvider;", "Lio/ktor/client/features/auth/AuthProvider;", "username", "", "password", "realm", "sendWithoutRequest", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "defaultCharset", "Ljava/nio/charset/Charset;", "getSendWithoutRequest", "()Z", "addRequestHeaders", "", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "(Lio/ktor/client/request/HttpRequestBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "constructBasicAuthValue", "constructBasicAuthValue$ktor_client_auth", "isApplicable", "auth", "Lio/ktor/http/auth/HttpAuthHeader;", "ktor-client-auth"})
public final class BasicAuthProvider
implements AuthProvider {
    private final Charset defaultCharset;
    private final String username;
    private final String password;
    private final String realm;
    private final boolean sendWithoutRequest;

    @Override
    public boolean isApplicable(@NotNull HttpAuthHeader auth) {
        Intrinsics.checkParameterIsNotNull((Object)auth, (String)"auth");
        if (Intrinsics.areEqual((Object)auth.getAuthScheme(), (Object)"Basic") ^ true) {
            return false;
        }
        if (this.realm != null) {
            if (!(auth instanceof HttpAuthHeader.Parameterized)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((HttpAuthHeader.Parameterized)auth).parameter("realm"), (Object)this.realm);
        }
        return true;
    }

    @Override
    @Nullable
    public Object addRequestHeaders(@NotNull HttpRequestBuilder request, @NotNull Continuation<? super Unit> $completion) {
        request.getHeaders().set(HttpHeaders.INSTANCE.getAuthorization(), this.constructBasicAuthValue$ktor_client_auth());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String constructBasicAuthValue$ktor_client_auth() {
        void $this$toByteArray$iv;
        String authString;
        String string = authString = this.username + ':' + this.password;
        Charset charset$iv = this.defaultCharset;
        boolean $i$f$toByteArray = false;
        CharsetEncoder charsetEncoder = charset$iv.newEncoder();
        Intrinsics.checkExpressionValueIsNotNull((Object)charsetEncoder, (String)"charset.newEncoder()");
        String authBuf = Base64Kt.encodeBase64((byte[])CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)((CharSequence)$this$toByteArray$iv), (int)0, (int)$this$toByteArray$iv.length()));
        return "Basic " + authBuf;
    }

    @Override
    public boolean getSendWithoutRequest() {
        return this.sendWithoutRequest;
    }

    public BasicAuthProvider(@NotNull String username, @NotNull String password, @Nullable String realm, boolean sendWithoutRequest) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.username = username;
        this.password = password;
        this.realm = realm;
        this.sendWithoutRequest = sendWithoutRequest;
        this.defaultCharset = Charsets.UTF_8;
    }

    public /* synthetic */ BasicAuthProvider(String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, string2, string3, bl);
    }
}

