/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.cio;

import io.ktor.client.call.HttpClientCall;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.response.HttpResponse;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.cio.CIOHeaders;
import io.ktor.http.cio.Response;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CompletableDeferred;
import kotlinx.coroutines.experimental.CompletableDeferredKt;
import kotlinx.coroutines.experimental.io.ByteReadChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010&\u001a\u00020\u0013H\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lio/ktor/client/engine/cio/CIOHttpResponse;", "Lio/ktor/client/response/HttpResponse;", "request", "Lio/ktor/client/request/HttpRequest;", "requestTime", "Ljava/util/Date;", "content", "Lkotlinx/coroutines/experimental/io/ByteReadChannel;", "response", "Lio/ktor/http/cio/Response;", "(Lio/ktor/client/request/HttpRequest;Ljava/util/Date;Lkotlinx/coroutines/experimental/io/ByteReadChannel;Lio/ktor/http/cio/Response;)V", "call", "Lio/ktor/client/call/HttpClientCall;", "getCall", "()Lio/ktor/client/call/HttpClientCall;", "getContent", "()Lkotlinx/coroutines/experimental/io/ByteReadChannel;", "executionContext", "Lkotlinx/coroutines/experimental/CompletableDeferred;", "", "getExecutionContext", "()Lkotlinx/coroutines/experimental/CompletableDeferred;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "getRequestTime", "()Ljava/util/Date;", "responseTime", "getResponseTime", "status", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "version", "Lio/ktor/http/HttpProtocolVersion;", "getVersion", "()Lio/ktor/http/HttpProtocolVersion;", "close", "ktor-client-cio"})
public final class CIOHttpResponse
implements HttpResponse {
    @NotNull
    private final HttpClientCall call;
    @NotNull
    private final HttpStatusCode status;
    @NotNull
    private final HttpProtocolVersion version;
    @NotNull
    private final Headers headers;
    @NotNull
    private final Date responseTime;
    @NotNull
    private final CompletableDeferred<Unit> executionContext;
    @NotNull
    private final Date requestTime;
    @NotNull
    private final ByteReadChannel content;
    private final Response response;

    @NotNull
    public HttpClientCall getCall() {
        return this.call;
    }

    @NotNull
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @NotNull
    public HttpProtocolVersion getVersion() {
        return this.version;
    }

    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public Date getResponseTime() {
        return this.responseTime;
    }

    @NotNull
    public CompletableDeferred<Unit> getExecutionContext() {
        return this.executionContext;
    }

    public void close() {
        this.response.release();
        this.getExecutionContext().complete((Object)Unit.INSTANCE);
    }

    @NotNull
    public Date getRequestTime() {
        return this.requestTime;
    }

    @NotNull
    public ByteReadChannel getContent() {
        return this.content;
    }

    public CIOHttpResponse(@NotNull HttpRequest request, @NotNull Date requestTime, @NotNull ByteReadChannel content, @NotNull Response response) {
        Headers headers;
        HeadersBuilder headersBuilder;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)requestTime, (String)"requestTime");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.requestTime = requestTime;
        this.content = content;
        this.response = response;
        this.call = request.getCall();
        this.status = HttpStatusCode.Companion.fromValue(this.response.getStatus());
        this.version = HttpProtocolVersion.Companion.getHTTP_1_1();
        Headers.Companion companion = Headers.Companion;
        CIOHttpResponse cIOHttpResponse = this;
        HeadersBuilder $receiver = headersBuilder = new HeadersBuilder(0, 1, null);
        CIOHeaders origin = new CIOHeaders(this.response.getHeaders());
        Iterable $receiver$iv = origin.names();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            $receiver.appendAll(it, (Iterable)origin.getAll(it));
        }
        cIOHttpResponse.headers = headers = headersBuilder.build();
        this.responseTime = new Date();
        this.executionContext = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }
}

