/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.cio;

import io.ktor.client.call.HttpClientCall;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.response.HttpResponse;
import io.ktor.http.Headers;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.cio.Response;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.io.ByteReadChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lio/ktor/client/engine/cio/CIOHttpResponse;", "Lio/ktor/client/response/HttpResponse;", "request", "Lio/ktor/client/request/HttpRequest;", "headers", "Lio/ktor/http/Headers;", "requestTime", "Lio/ktor/util/date/GMTDate;", "content", "Lkotlinx/coroutines/io/ByteReadChannel;", "response", "Lio/ktor/http/cio/Response;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/ktor/client/request/HttpRequest;Lio/ktor/http/Headers;Lio/ktor/util/date/GMTDate;Lkotlinx/coroutines/io/ByteReadChannel;Lio/ktor/http/cio/Response;Lkotlin/coroutines/CoroutineContext;)V", "call", "Lio/ktor/client/call/HttpClientCall;", "getCall", "()Lio/ktor/client/call/HttpClientCall;", "getContent", "()Lkotlinx/coroutines/io/ByteReadChannel;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getHeaders", "()Lio/ktor/http/Headers;", "getRequestTime", "()Lio/ktor/util/date/GMTDate;", "responseTime", "getResponseTime", "status", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "version", "Lio/ktor/http/HttpProtocolVersion;", "getVersion", "()Lio/ktor/http/HttpProtocolVersion;", "ktor-client-cio"})
public final class CIOHttpResponse
implements HttpResponse {
    @NotNull
    private final HttpClientCall call;
    @NotNull
    private final HttpStatusCode status;
    @NotNull
    private final HttpProtocolVersion version;
    @NotNull
    private final GMTDate responseTime;
    @NotNull
    private final Headers headers;
    @NotNull
    private final GMTDate requestTime;
    @NotNull
    private final ByteReadChannel content;
    @NotNull
    private final CoroutineContext coroutineContext;

    @NotNull
    public HttpClientCall getCall() {
        return this.call;
    }

    @NotNull
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @NotNull
    public HttpProtocolVersion getVersion() {
        return this.version;
    }

    @NotNull
    public GMTDate getResponseTime() {
        return this.responseTime;
    }

    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public GMTDate getRequestTime() {
        return this.requestTime;
    }

    @NotNull
    public ByteReadChannel getContent() {
        return this.content;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public CIOHttpResponse(@NotNull HttpRequest request2, @NotNull Headers headers, @NotNull GMTDate requestTime, @NotNull ByteReadChannel content, @NotNull Response response, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        Intrinsics.checkParameterIsNotNull((Object)requestTime, (String)"requestTime");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)coroutineContext, (String)"coroutineContext");
        this.headers = headers;
        this.requestTime = requestTime;
        this.content = content;
        this.coroutineContext = coroutineContext;
        this.call = request2.getCall();
        this.status = new HttpStatusCode(response.getStatus(), ((Object)response.getStatusText()).toString());
        this.version = HttpProtocolVersion.Companion.parse(response.getVersion());
        this.responseTime = DateJvmKt.GMTDate$default(null, (int)1, null);
    }

    @NotNull
    public /* synthetic */ Job getExecutionContext() {
        return HttpResponse.DefaultImpls.getExecutionContext((HttpResponse)this);
    }

    public void close() {
        HttpResponse.DefaultImpls.close((HttpResponse)this);
    }
}

