/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.HttpMethod;
import io.ktor.http.cio.ChunkedTransferEncodingKt;
import io.ktor.http.cio.ConnectionOptions;
import io.ktor.http.cio.HttpBodyKt;
import io.ktor.http.cio.HttpHeadersMap;
import io.ktor.http.cio.Request;
import io.ktor.http.cio.internals.CharsKt;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.intrinsics.IntrinsicsKt;
import kotlin.coroutines.experimental.jvm.internal.CoroutineImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.io.ByteReadChannel;
import kotlinx.coroutines.experimental.io.ByteReadChannelKt;
import kotlinx.coroutines.experimental.io.ByteWriteChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a)\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017\u001a=\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u0082\u0002\u0004\n\u0002\b\t\u00a8\u0006\u0019"}, d2={"expectHttpBody", "", "method", "Lio/ktor/http/HttpMethod;", "contentLength", "", "transferEncoding", "", "connectionOptions", "Lio/ktor/http/cio/ConnectionOptions;", "contentType", "request", "Lio/ktor/http/cio/Request;", "expectHttpUpgrade", "upgrade", "parseHttpBody", "", "headers", "Lio/ktor/http/cio/HttpHeadersMap;", "input", "Lkotlinx/coroutines/experimental/io/ByteReadChannel;", "out", "Lkotlinx/coroutines/experimental/io/ByteWriteChannel;", "(Lio/ktor/http/cio/HttpHeadersMap;Lkotlinx/coroutines/experimental/io/ByteReadChannel;Lkotlinx/coroutines/experimental/io/ByteWriteChannel;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "(JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Lkotlinx/coroutines/experimental/io/ByteReadChannel;Lkotlinx/coroutines/experimental/io/ByteWriteChannel;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "ktor-http-cio"})
public final class HttpBodyKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean expectHttpUpgrade(@NotNull HttpMethod method, @Nullable CharSequence upgrade, @Nullable ConnectionOptions connectionOptions) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (!Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getGet())) return false;
        if (upgrade == null) return false;
        ConnectionOptions connectionOptions2 = connectionOptions;
        if (connectionOptions2 == null) return false;
        if (!connectionOptions2.getUpgrade()) return false;
        return true;
    }

    public static final boolean expectHttpUpgrade(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return HttpBodyKt.expectHttpUpgrade(request.getMethod(), request.getHeaders().get("Upgrade"), ConnectionOptions.Companion.parse(request.getHeaders().get("Connection")));
    }

    public static final boolean expectHttpBody(@NotNull HttpMethod method, long contentLength, @Nullable CharSequence transferEncoding, @Nullable ConnectionOptions connectionOptions, @Nullable CharSequence contentType) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getGet()) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getHead()) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getOptions())) {
            return false;
        }
        if (transferEncoding != null) {
            return true;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        if (connectionOptions2 != null) {
            if (connectionOptions2.getClose()) {
                return true;
            }
        }
        if (contentLength != -1L) {
            return contentLength > 0L;
        }
        return contentType != null;
    }

    public static final boolean expectHttpBody(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        CharSequence charSequence = request.getHeaders().get("Content-Length");
        return HttpBodyKt.expectHttpBody(request.getMethod(), charSequence != null ? CharsKt.parseDecLong(charSequence) : -1L, request.getHeaders().get("Transfer-Encoding"), ConnectionOptions.Companion.parse(request.getHeaders().get("Connection")), request.getHeaders().get("Content-Type"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Object parseHttpBody(long l, @Nullable CharSequence charSequence, @Nullable ConnectionOptions connectionOptions, @NotNull ByteReadChannel byteReadChannel, @NotNull ByteWriteChannel byteWriteChannel, @NotNull Continuation<? super Unit> continuation) {
        ByteWriteChannel out;
        block19: {
            Object object;
            ByteReadChannel input;
            ConnectionOptions connectionOptions2;
            long contentLength;
            CharSequence transferEncoding;
            Object object2;
            Throwable throwable;
            Object object3;
            parseHttpBody.1 var9_6;
            block18: {
                Object object4;
                block17: {
                    if (continuation instanceof parseHttpBody.1 && ((var9_6 = continuation).getLabel() & Integer.MIN_VALUE) != 0) {
                        parseHttpBody.1 v0 = var9_6;
                        v0.setLabel(v0.getLabel() - Integer.MIN_VALUE);
                    } else {
                        var9_6 = new CoroutineImpl(continuation){
                            /* synthetic */ Object data;
                            /* synthetic */ Throwable exception;
                            long J$0;
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;

                            @Nullable
                            public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                                this.data = data;
                                this.exception = throwable;
                                this.label |= Integer.MIN_VALUE;
                                return HttpBodyKt.parseHttpBody(0L, null, null, null, null, (Continuation<? super Unit>)this);
                            }

                            final /* synthetic */ int getLabel() {
                                return this.label;
                            }

                            final /* synthetic */ void setLabel(int n) {
                                this.label = n;
                            }
                        };
                    }
                    object3 = var9_6.data;
                    throwable = var9_6.exception;
                    object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (var9_6.getLabel()) {
                        case 0: {
                            Object object5;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null) {
                                throw throwable2;
                            }
                            if (transferEncoding != null) {
                                if (!CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "chunked", 3, null)) break;
                                var9_6.J$0 = contentLength;
                                var9_6.L$0 = transferEncoding;
                                var9_6.L$1 = connectionOptions2;
                                var9_6.L$2 = input;
                                var9_6.L$3 = out;
                                var9_6.setLabel(1);
                                object5 = ChunkedTransferEncodingKt.decodeChunked(input, out, (Continuation<? super Unit>)var9_6);
                                if (object5 != object2) return object5;
                                return object2;
                            }
                            break block17;
                        }
                        case 1: {
                            out = (ByteWriteChannel)var9_6.L$3;
                            input = (ByteReadChannel)var9_6.L$2;
                            connectionOptions2 = (ConnectionOptions)var9_6.L$1;
                            transferEncoding = (CharSequence)var9_6.L$0;
                            contentLength = var9_6.J$0;
                            Throwable throwable3 = throwable;
                            if (throwable3 != null) {
                                throw throwable3;
                            }
                            Object object5 = object3;
                            return object5;
                        }
                    }
                    if (!CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "identity", 3, null)) {
                        out.close((Throwable)new IOException("Unsupported transfer-encoding " + transferEncoding));
                    }
                }
                if (contentLength != -1L) {
                    var9_6.J$0 = contentLength;
                    var9_6.L$0 = transferEncoding;
                    var9_6.L$1 = connectionOptions2;
                    var9_6.L$2 = input;
                    var9_6.L$3 = out;
                    var9_6.setLabel(2);
                    object4 = ByteReadChannelKt.copyTo((ByteReadChannel)input, (ByteWriteChannel)out, (long)contentLength, (Continuation)var9_6);
                    if (object4 != object2) return Unit.INSTANCE;
                    return object2;
                }
                break block18;
                {
                    case 2: {
                        out = (ByteWriteChannel)var9_6.L$3;
                        input = (ByteReadChannel)var9_6.L$2;
                        connectionOptions2 = (ConnectionOptions)var9_6.L$1;
                        transferEncoding = (CharSequence)var9_6.L$0;
                        contentLength = var9_6.J$0;
                        Throwable throwable4 = throwable;
                        if (throwable4 != null) {
                            throw throwable4;
                        }
                        object4 = object3;
                        return Unit.INSTANCE;
                    }
                }
            }
            void v6 = connectionOptions2;
            if (v6 != null) {
                if (v6.getClose()) {
                    var9_6.J$0 = contentLength;
                    var9_6.L$0 = transferEncoding;
                    var9_6.L$1 = connectionOptions2;
                    var9_6.L$2 = input;
                    var9_6.L$3 = out;
                    var9_6.setLabel(3);
                    object = ByteReadChannelKt.copyTo$default((ByteReadChannel)input, (ByteWriteChannel)out, (long)0L, (Continuation)var9_6, (int)2, null);
                    if (object != object2) return Unit.INSTANCE;
                    return object2;
                }
            }
            break block19;
            {
                case 3: {
                    out = (ByteWriteChannel)var9_6.L$3;
                    input = (ByteReadChannel)var9_6.L$2;
                    connectionOptions2 = (ConnectionOptions)var9_6.L$1;
                    transferEncoding = (CharSequence)var9_6.L$0;
                    contentLength = var9_6.J$0;
                    Throwable throwable5 = throwable;
                    if (throwable5 != null) {
                        throw throwable5;
                    }
                    object = object3;
                    return Unit.INSTANCE;
                }
            }
        }
        out.close((Throwable)new IOException("Failed to parse request body: request body length should be specified, chunked transfer encoding should be used or keep-alive should be disabled (connection: close)"));
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public static final Object parseHttpBody(@NotNull HttpHeadersMap headers, @NotNull ByteReadChannel input, @NotNull ByteWriteChannel out, @NotNull Continuation<? super Unit> continuation) {
        CharSequence charSequence = headers.get("Content-Length");
        return HttpBodyKt.parseHttpBody(charSequence != null ? CharsKt.parseDecLong(charSequence) : -1L, headers.get("Transfer-Encoding"), ConnectionOptions.Companion.parse(headers.get("Connection")), input, out, continuation);
    }
}

