/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.ParserException;
import io.ktor.http.cio.internals.MutableRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u000b"}, d2={"findColonOrSpace", "", "text", "", "range", "Lio/ktor/http/cio/internals/MutableRange;", "findSpaceOrEnd", "nextToken", "skipSpaces", "", "skipSpacesAndColon", "ktor-http-cio"})
public final class TokenizerKt {
    @NotNull
    public static final CharSequence nextToken(@NotNull CharSequence text, @NotNull MutableRange range) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        int spaceOrEnd = TokenizerKt.findSpaceOrEnd(text, range);
        CharSequence s = text.subSequence(range.getStart(), spaceOrEnd);
        range.setStart(spaceOrEnd);
        return s;
    }

    public static final void skipSpaces(@NotNull CharSequence text, @NotNull MutableRange range) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        int idx = range.getStart();
        int end = range.getEnd();
        if (idx >= end || text.charAt(idx) != ' ') {
            return;
        }
        ++idx;
        while (idx < end && text.charAt(idx) == ' ') {
            ++idx;
        }
        range.setStart(idx);
    }

    public static final void skipSpacesAndColon(@NotNull CharSequence text, @NotNull MutableRange range) {
        int idx;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        int end = range.getEnd();
        int colons = 0;
        for (idx = range.getStart(); idx < end; ++idx) {
            char ch = text.charAt(idx);
            if (ch == ':') {
                if (++colons <= 1) continue;
                throw (Throwable)new ParserException("Multiple colons in header");
            }
            if (ch != ' ') break;
        }
        range.setStart(idx);
    }

    public static final int findSpaceOrEnd(@NotNull CharSequence text, @NotNull MutableRange range) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        int idx = range.getStart();
        int end = range.getEnd();
        if (idx >= end || text.charAt(idx) == ' ') {
            return idx;
        }
        ++idx;
        while (idx < end) {
            if (text.charAt(idx) == ' ') {
                return idx;
            }
            ++idx;
        }
        return idx;
    }

    public static final int findColonOrSpace(@NotNull CharSequence text, @NotNull MutableRange range) {
        int idx;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        int end = range.getEnd();
        for (idx = range.getStart(); idx < end; ++idx) {
            char ch = text.charAt(idx);
            if (ch != ' ' && ch != ':') continue;
            return idx;
        }
        return idx;
    }
}

