/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import java.time.Clock;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.coroutines.experimental.intrinsics.IntrinsicsKt;
import kotlin.coroutines.experimental.jvm.internal.CoroutineIntrinsics;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.experimental.AbstractCoroutine;
import kotlinx.coroutines.experimental.CompletedExceptionally;
import kotlinx.coroutines.experimental.CoroutineScope;
import kotlinx.coroutines.experimental.DisposableHandle;
import kotlinx.coroutines.experimental.Job;
import kotlinx.coroutines.experimental.JobKt;
import kotlinx.coroutines.experimental.TimeoutCancellationException;
import kotlinx.coroutines.experimental.internal.LockFreeLinkedListHead;
import kotlinx.coroutines.experimental.internal.LockFreeLinkedListNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003'()B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0010J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u0004\u0018\u00010\u00012\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0002J@\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2'\u0010!\u001a#\b\u0001\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0$\u0012\u0006\u0012\u0004\u0018\u00010\u00010\"\u00a2\u0006\u0002\b%H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\t\u00a8\u0006*"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue;", "", "timeoutMillis", "", "clock", "Ljava/time/Clock;", "exceptionFactory", "Lkotlin/Function0;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(JLjava/time/Clock;Lkotlin/jvm/functions/Function0;)V", "cancelled", "", "head", "Lkotlinx/coroutines/experimental/internal/LockFreeLinkedListHead;", "cancel", "", "cancellationException", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/experimental/CancellationException;", "process", "now", "register", "Lkotlinx/coroutines/experimental/DisposableHandle;", "r", "Lkotlinx/coroutines/experimental/Job;", "unwrapResult", "c", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$WeakTimeoutCoroutine;", "handle", "result", "withTimeout", "T", "block", "Lkotlin/Function2;", "Lkotlinx/coroutines/experimental/CoroutineScope;", "Lkotlin/coroutines/experimental/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "Cancellable", "JobTask", "WeakTimeoutCoroutine", "ktor-http-cio"})
public final class WeakTimeoutQueue {
    private final LockFreeLinkedListHead head;
    private volatile boolean cancelled;
    private final long timeoutMillis;
    private final Clock clock;
    private final Function0<Exception> exceptionFactory;

    @NotNull
    public final DisposableHandle register(@NotNull Job r) {
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        long now = this.clock.millis();
        LockFreeLinkedListHead head = this.head;
        if (this.cancelled) {
            throw (Throwable)this.cancellationException();
        }
        JobTask cancellable = new JobTask(now + this.timeoutMillis, r);
        head.addLast((LockFreeLinkedListNode)cancellable);
        this.process(now, head, this.cancelled);
        if (this.cancelled) {
            CancellationException e = this.cancellationException();
            cancellable.cancel(e);
            throw (Throwable)e;
        }
        return cancellable;
    }

    public final void cancel() {
        this.cancelled = true;
        this.process();
    }

    public final void process() {
        this.process(this.clock.millis(), this.head, this.cancelled);
    }

    @Nullable
    public final <T> Object withTimeout(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> continuation) {
        Object object;
        Continuation c = CoroutineIntrinsics.normalizeContinuation(continuation);
        WeakTimeoutCoroutine wrapped = new WeakTimeoutCoroutine(c.getContext(), c);
        DisposableHandle handle = this.register((Job)wrapped);
        JobKt.disposeOnCompletion((Job)((Job)wrapped), (DisposableHandle)handle);
        try {
            if (wrapped.isCancelled()) {
                throw (Throwable)wrapped.getCancellationException();
            }
            CompletedExceptionally completedExceptionally = object = block;
            if (completedExceptionally == null) {
                throw new TypeCastException("null cannot be cast to non-null type (R, kotlin.coroutines.experimental.Continuation<T>) -> kotlin.Any?");
            }
            object = ((Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity((Object)completedExceptionally, (int)2)).invoke(wrapped, (Object)wrapped);
        }
        catch (Throwable t) {
            object = new CompletedExceptionally(t);
        }
        CompletedExceptionally result = object;
        return this.unwrapResult(wrapped, handle, result);
    }

    private final Object unwrapResult(WeakTimeoutCoroutine<?> c, DisposableHandle handle, Object result) {
        Object object;
        Object suspended = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        if (result == suspended) {
            object = result;
        } else if (c.isCompleted()) {
            object = suspended;
        } else {
            if (result instanceof CompletedExceptionally) {
                handle.dispose();
                throw ((CompletedExceptionally)result).getException();
            }
            handle.dispose();
            object = result;
        }
        return object;
    }

    private final void process(long now, LockFreeLinkedListHead head, boolean cancelled) {
        Throwable e = null;
        while (true) {
            Cancellable p;
            Object object;
            if (!((object = head.getNext()) instanceof Cancellable)) {
                object = null;
            }
            if ((Cancellable)((Object)object) == null) {
                break;
            }
            if (!cancelled && p.getDeadline() > now) break;
            if (!p.isActive() || !p.remove()) continue;
            if (e == null) {
                e = cancelled ? (Throwable)this.cancellationException() : (Throwable)this.exceptionFactory.invoke();
            }
            p.cancel(e);
        }
    }

    private final CancellationException cancellationException() {
        return new CancellationException("Timeout queue has been cancelled");
    }

    public WeakTimeoutQueue(long timeoutMillis, @NotNull Clock clock, @NotNull Function0<? extends Exception> exceptionFactory) {
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull(exceptionFactory, (String)"exceptionFactory");
        this.timeoutMillis = timeoutMillis;
        this.clock = clock;
        this.exceptionFactory = exceptionFactory;
        this.head = new LockFreeLinkedListHead();
    }

    public /* synthetic */ WeakTimeoutQueue(final long l, Clock clock, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkExpressionValueIsNotNull((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        if ((n & 4) != 0) {
            function0 = (Function0)new Function0<TimeoutCancellationException>(){

                @NotNull
                public final TimeoutCancellationException invoke() {
                    return new TimeoutCancellationException("Timeout of " + l + " ms exceeded");
                }
            };
        }
        this(l, clock, (Function0<? extends Exception>)function0);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0010"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$Cancellable;", "Lkotlinx/coroutines/experimental/internal/LockFreeLinkedListNode;", "Lkotlinx/coroutines/experimental/DisposableHandle;", "deadline", "", "(J)V", "getDeadline", "()J", "isActive", "", "()Z", "cancel", "", "t", "", "dispose", "ktor-http-cio"})
    private static abstract class Cancellable
    extends LockFreeLinkedListNode
    implements DisposableHandle {
        private final long deadline;

        public boolean isActive() {
            return !this.isRemoved();
        }

        public abstract void cancel(@NotNull Throwable var1);

        public void dispose() {
            this.remove();
        }

        public final long getDeadline() {
            return this.deadline;
        }

        public Cancellable(long deadline) {
            this.deadline = deadline;
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="dispose()"), message="Replace with `dispose`")
        public void unregister() {
            DisposableHandle.DefaultImpls.unregister((DisposableHandle)this);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$JobTask;", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Cancellable;", "deadline", "", "job", "Lkotlinx/coroutines/experimental/Job;", "(JLkotlinx/coroutines/experimental/Job;)V", "isActive", "", "()Z", "cancel", "", "t", "", "ktor-http-cio"})
    private static final class JobTask
    extends Cancellable {
        private final Job job;

        @Override
        public boolean isActive() {
            return super.isActive() && this.job.isActive();
        }

        @Override
        public void cancel(@NotNull Throwable t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            this.job.cancel(t);
        }

        public JobTask(long deadline, @NotNull Job job) {
            Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
            super(deadline);
            this.job = job;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$WeakTimeoutCoroutine;", "T", "Lkotlinx/coroutines/experimental/AbstractCoroutine;", "Lkotlin/coroutines/experimental/Continuation;", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "delegate", "(Lkotlin/coroutines/experimental/CoroutineContext;Lkotlin/coroutines/experimental/Continuation;)V", "getDelegate", "()Lkotlin/coroutines/experimental/Continuation;", "onCompleted", "", "value", "(Ljava/lang/Object;)V", "onCompletedExceptionally", "exception", "", "ktor-http-cio"})
    private static final class WeakTimeoutCoroutine<T>
    extends AbstractCoroutine<T>
    implements Continuation<T> {
        @NotNull
        private final Continuation<T> delegate;

        protected void onCompleted(T value) {
            this.delegate.resume(value);
        }

        protected void onCompletedExceptionally(@NotNull Throwable exception) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            this.delegate.resumeWithException(exception);
        }

        @NotNull
        public final Continuation<T> getDelegate() {
            return this.delegate;
        }

        public WeakTimeoutCoroutine(@NotNull CoroutineContext context, @NotNull Continuation<? super T> delegate) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
            super(context, true);
            this.delegate = delegate;
        }
    }
}

