/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a0\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a\"\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005\u001a\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005\u00a8\u0006\u0015"}, d2={"charToHexDigit", "", "c2", "", "decodeImpl", "", "text", "", "start", "end", "prefixEnd", "plusIsSpace", "", "charset", "Ljava/nio/charset/Charset;", "decodeScan", "decodeURLPart", "decodeURLQueryComponent", "encodeURLPart", "s", "encodeURLQueryComponent", "ktor-http"})
public final class CodecsKt {
    @NotNull
    public static final String encodeURLQueryComponent(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        String string = URLEncoder.encode(s, Charsets.UTF_8.name());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLEncoder.encode(s, Charsets.UTF_8.name())");
        return string;
    }

    @NotNull
    public static final String encodeURLPart(@NotNull String s) {
        String encoded;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        String string = encoded = URLEncoder.encode(s, Charsets.UTF_8.name());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"encoded");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null), (String)"%2b", (String)"+", (boolean)false, (int)4, null), (String)"%2B", (String)"+", (boolean)false, (int)4, null), (String)"*", (String)"%2A", (boolean)false, (int)4, null), (String)"%7E", (String)"~", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String decodeURLQueryComponent(@NotNull CharSequence text, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return CodecsKt.decodeScan(text, start, end, true, Charsets.UTF_8);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String decodeURLQueryComponent$default(CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return CodecsKt.decodeURLQueryComponent(charSequence, n, n2);
    }

    @NotNull
    public static final String decodeURLPart(@NotNull String text, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return CodecsKt.decodeScan(text, start, end, false, Charsets.UTF_8);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String decodeURLPart$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        return CodecsKt.decodeURLPart(string, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private static final String decodeScan(CharSequence text, int start, int end, boolean plusIsSpace, Charset charset) {
        int n = start;
        int n2 = end;
        while (n < n2) {
            void index;
            char ch = text.charAt((int)index);
            if (ch == '%' || plusIsSpace && ch == '+') {
                return CodecsKt.decodeImpl(text, start, end, (int)index, plusIsSpace, charset);
            }
            ++index;
        }
        if (start == 0 && end == text.length()) {
            return ((Object)text).toString();
        }
        CharSequence charSequence = text;
        return ((Object)charSequence.subSequence(start, end)).toString();
    }

    private static final String decodeImpl(CharSequence text, int start, int end, int prefixEnd, boolean plusIsSpace, Charset charset) {
        int length = end - start;
        int sbSize = length > 255 ? length / 3 : length;
        StringBuilder sb = new StringBuilder(sbSize);
        if (prefixEnd > start) {
            sb.append(text, start, prefixEnd);
        }
        int index = prefixEnd;
        byte[] bytes2 = null;
        while (index < end) {
            char c = text.charAt(index);
            if (plusIsSpace && c == '+') {
                sb.append(' ');
                ++index;
                continue;
            }
            if (c == '%') {
                if (bytes2 == null) {
                    bytes2 = new byte[(end - index) / 3];
                }
                int count = 0;
                while (index < end && text.charAt(index) == '%') {
                    if (index + 2 >= end) {
                        URISyntaxException uRISyntaxException;
                        CharSequence charSequence = text;
                        StringBuilder stringBuilder = new StringBuilder().append("Incomplete trailing HEX escape: ");
                        String string = ((Object)text).toString();
                        URISyntaxException uRISyntaxException2 = uRISyntaxException;
                        URISyntaxException uRISyntaxException3 = uRISyntaxException;
                        int n = charSequence.length();
                        String string2 = ((Object)charSequence.subSequence(index, n)).toString();
                        uRISyntaxException2(string, stringBuilder.append(string2).toString(), index);
                        throw (Throwable)uRISyntaxException3;
                    }
                    int digit1 = CodecsKt.charToHexDigit(text.charAt(index + 1));
                    int digit2 = CodecsKt.charToHexDigit(text.charAt(index + 2));
                    if (digit1 == -1 || digit2 == -1) {
                        throw (Throwable)new URISyntaxException(((Object)text).toString(), "Wrong HEX escape: %" + text.charAt(index + 1) + "" + text.charAt(index + 2), index);
                    }
                    bytes2[count++] = (byte)(digit1 * 16 + digit2);
                    index += 3;
                }
                sb.append((CharSequence)new String(bytes2, 0, count, charset));
                continue;
            }
            sb.append(c);
            ++index;
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final int charToHexDigit(char c2) {
        char c = c2;
        char c3 = c;
        return '0' <= c3 && '9' >= c3 ? c2 - 48 : ('A' <= (c3 = c) && 'F' >= c3 ? c2 - 65 + 10 : ('a' <= (c3 = c) && 'f' >= c3 ? c2 - 97 + 10 : -1));
    }
}

