/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.FileContentTypeKt;
import io.ktor.util.PathKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u0001\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u0011H\u0002\u001aL\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u0002H\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00030\u0001\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u00112$\u0010\u0013\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u00150\u0014H\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0004*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0012\u0010\u0016\u001a\u00020\u0004*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001a\u001a\u0012\u0010\u001b\u001a\u00020\u0004*\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0002\u001a\u0012\u0010\u001d\u001a\u00020\u0004*\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0002\u001a\u0010\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003*\u00020\u0004\u001a\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00172\u0006\u0010!\u001a\u00020\u0002\u001a\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0002\u001a<\u0010#\u001a\u0014\u0012\u0004\u0012\u0002H\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00030\u0001\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u0011*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u00150$H\u0002\u001a\u0012\u0010%\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\f\u0010&\u001a\u00020\u0004*\u00020\u0002H\u0002\"-\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\t\u001a\u00020\u0002X\u0082D\u00a2\u0006\u0002\n\u0000\"-\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\b\u001a\u0004\b\u000b\u0010\u0006\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"contentTypesByExtensions", "", "", "", "Lio/ktor/http/ContentType;", "getContentTypesByExtensions", "()Ljava/util/Map;", "contentTypesByExtensions$delegate", "Lkotlin/Lazy;", "contentTypesFileName", "extensionsByContentType", "getExtensionsByContentType", "extensionsByContentType$delegate", "logged", "", "logErrorAndReturnEmpty", "A", "B", "processRecords", "operation", "Lkotlin/Function2;", "Lkotlin/Pair;", "defaultForFile", "Lio/ktor/http/ContentType$Companion;", "file", "Ljava/io/File;", "Ljava/nio/file/Path;", "defaultForFileExtension", "extension", "defaultForFilePath", "path", "fileExtensions", "fromFileExtension", "ext", "fromFilePath", "groupByPairs", "Lkotlin/sequences/Sequence;", "selectDefault", "toContentType", "ktor-http"})
public final class FileContentTypeKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final String contentTypesFileName = "mimelist.csv";
    private static final Lazy contentTypesByExtensions$delegate;
    private static final Lazy extensionsByContentType$delegate;
    private static boolean logged;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(FileContentTypeKt.class, (String)"ktor-http"), "contentTypesByExtensions", "getContentTypesByExtensions()Ljava/util/Map;")), (KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(FileContentTypeKt.class, (String)"ktor-http"), "extensionsByContentType", "getExtensionsByContentType()Ljava/util/Map;"))};
        contentTypesFileName = contentTypesFileName;
        contentTypesByExtensions$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)contentTypesByExtensions.2.INSTANCE);
        extensionsByContentType$delegate = LazyKt.lazy((Function0)extensionsByContentType.2.INSTANCE);
    }

    @NotNull
    public static final ContentType defaultForFileExtension(@NotNull ContentType.Companion $receiver, @NotNull String extension) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, extension));
    }

    @NotNull
    public static final ContentType defaultForFilePath(@NotNull ContentType.Companion $receiver, @NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFilePath(ContentType.Companion, path2));
    }

    @NotNull
    public static final ContentType defaultForFile(@NotNull ContentType.Companion $receiver, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, FilesKt.getExtension((File)file)));
    }

    @NotNull
    public static final ContentType defaultForFile(@NotNull ContentType.Companion $receiver, @NotNull Path file) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, PathKt.getExtension((Path)file)));
    }

    @NotNull
    public static final List<ContentType> fromFilePath(@NotNull ContentType.Companion $receiver, @NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        String string = "/\\";
        Object object = path2;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        Object object2 = cArray;
        int slashIndex = StringsKt.lastIndexOfAny$default((CharSequence)object, (char[])object2, (int)0, (boolean)false, (int)6, null);
        int index = StringsKt.indexOf$default((CharSequence)path2, (char)'.', (int)(slashIndex + 1), (boolean)false, (int)4, null);
        if (index == -1) {
            return CollectionsKt.emptyList();
        }
        String string2 = path2;
        int n = index + 1;
        object = $receiver;
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        object2 = string3;
        return FileContentTypeKt.fromFileExtension((ContentType.Companion)object, (String)object2);
    }

    @NotNull
    public static final List<ContentType> fromFileExtension(@NotNull ContentType.Companion $receiver, @NotNull String ext) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
        String current = StringsKt.removePrefix((String)ext, (CharSequence)".");
        while ((charSequence = (CharSequence)current).length() > 0) {
            List<ContentType> type = FileContentTypeKt.getContentTypesByExtensions().get(current);
            if (type != null) {
                return type;
            }
            current = StringsKt.substringAfter((String)current, (String)".", (String)"");
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final List<String> fileExtensions(@NotNull ContentType $receiver) {
        List<String> list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<String> list2 = FileContentTypeKt.getExtensionsByContentType().get($receiver);
        if (list2 == null) {
            list2 = list = FileContentTypeKt.getExtensionsByContentType().get($receiver.withoutParameters());
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final ContentType selectDefault(@NotNull List<ContentType> $receiver) {
        ContentType contentType2;
        ContentType contentType3 = (ContentType)CollectionsKt.firstOrNull($receiver);
        if (contentType3 == null) {
            contentType3 = contentType2 = ContentType.Application.INSTANCE.getOctetStream();
        }
        if (Intrinsics.areEqual((Object)contentType2.getContentType(), (Object)"text") && ContentTypesKt.charset(contentType2) == null) {
            return ContentTypesKt.withCharset(contentType2, Charsets.UTF_8);
        }
        return contentType2;
    }

    private static final Map<String, List<ContentType>> getContentTypesByExtensions() {
        Lazy lazy = contentTypesByExtensions$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        return (Map)lazy.getValue();
    }

    private static final Map<ContentType, List<String>> getExtensionsByContentType() {
        Lazy lazy = extensionsByContentType$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[1];
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <A, B> Map<A, List<B>> processRecords(Function2<? super String, ? super ContentType, ? extends Pair<? extends A, ? extends B>> operation) {
        InputStream stream;
        InputStream inputStream = ContentType.class.getClassLoader().getResourceAsStream(contentTypesFileName);
        if (inputStream == null) {
            return FileContentTypeKt.logErrorAndReturnEmpty();
        }
        InputStream inputStream2 = stream = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = inputStream2;
        object2 = new InputStreamReader((InputStream)object2, (Charset)object);
        int n = 8192;
        Reader $receiver$iv = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = $receiver$iv;
        int n2 = 8192;
        object = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n2);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)object;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            object2 = FileContentTypeKt.groupByPairs(SequencesKt.mapNotNull((Sequence)lines, (Function1)new Function1<String, Pair<? extends A, ? extends B>>(operation){
                final /* synthetic */ Function2 $operation$inlined;
                {
                    this.$operation$inlined = function2;
                    super(1);
                }

                @Nullable
                public final Pair<A, B> invoke(@NotNull String it) {
                    Pair pair;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    CharSequence charSequence = it;
                    String line = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                    charSequence = line;
                    if (!(charSequence.length() == 0)) {
                        int index = StringsKt.indexOf$default((CharSequence)line, (char)',', (int)0, (boolean)false, (int)6, null);
                        String string = line;
                        int n = 0;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n, index);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String extension = string3;
                        String string4 = line;
                        int n2 = index + 1;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.substring(n2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                        String mime = string6;
                        string4 = StringsKt.removePrefix((String)extension, (CharSequence)".");
                        Function2 function2 = this.$operation$inlined;
                        String string7 = string4;
                        if (string7 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string8 = string7.toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
                        String string9 = string8;
                        pair = (Pair)function2.invoke((Object)string9, (Object)FileContentTypeKt.access$toContentType(mime));
                    } else {
                        pair = null;
                    }
                    return pair;
                }
            }));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return object2;
    }

    private static final <A, B> Map<A, B> logErrorAndReturnEmpty() {
        if (!logged) {
            LoggerFactory.getLogger((String)Reflection.getOrCreateKotlinClass(ContentType.class).getQualifiedName()).error("Resource " + contentTypesFileName + " is missing");
            logged = true;
        }
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final <A, B> Map<A, List<B>> groupByPairs(@NotNull Sequence<? extends Pair<? extends A, ? extends B>> $receiver) {
        Iterable list$iv$iv;
        Object value$iv$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = $receiver;
        Sequence<? extends Pair<? extends A, ? extends B>> sequence = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            Pair it = (Pair)element$iv$iv;
            Object key$iv$iv = it.getFirst();
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void $receiver$iv$iv2;
            void it;
            void it$iv$iv;
            Map.Entry $i$a$1$groupBy = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            Iterable $receiver$iv2 = (Iterable)it.getValue();
            list$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it2;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                Object object = it2.getSecond();
                collection.add(object);
            }
            List list = (List)destination$iv$iv2;
            map2.put(k2, list);
        }
        return destination$iv$iv;
    }

    private static final ContentType toContentType(@NotNull String $receiver) {
        ContentType contentType2;
        try {
            contentType2 = ContentType.Companion.parse($receiver);
        }
        catch (Throwable e) {
            throw (Throwable)new IllegalArgumentException("Failed to parse " + $receiver, e);
        }
        return contentType2;
    }

    @NotNull
    public static final /* synthetic */ ContentType access$toContentType(@NotNull String $receiver) {
        return FileContentTypeKt.toContentType($receiver);
    }

    @NotNull
    public static final /* synthetic */ Map access$processRecords(@NotNull Function2 operation) {
        return FileContentTypeKt.processRecords(operation);
    }
}

